/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.converter;

import com.oceanbase.tools.migrator.common.element.BytesColumn;
import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.StringColumn;
import com.oceanbase.tools.migrator.common.element.TimeColumn;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.util.BitStringUtils;
import com.oceanbase.tools.migrator.core.converter.AbstractColumnConverter;

public class PostgresColumnConverter
extends AbstractColumnConverter {
    @Override
    public Column convert(Column column, DataType dataType) {
        Column newColumn;
        this.checkSupported(column.getType());
        switch (dataType) {
            case NUMBER: {
                newColumn = new StringColumn(DataType.NUMBER, column.getString());
                break;
            }
            case LONG: {
                newColumn = new StringColumn(DataType.LONG, column.getString());
                break;
            }
            case DECIMAL: {
                newColumn = new StringColumn(DataType.DECIMAL, column.getString());
                break;
            }
            case DOUBLE: {
                newColumn = new StringColumn(DataType.DOUBLE, column.getString());
                break;
            }
            case JSON: 
            case STRING: {
                newColumn = new StringColumn(DataType.STRING, column.getString());
                break;
            }
            case TIMESTAMP: {
                newColumn = new StringColumn(DataType.TIMESTAMP, column.getString());
                break;
            }
            case BIT: {
                if (column.getValue() == null) {
                    newColumn = new StringColumn(DataType.STRING, column.getString());
                    break;
                }
                String bitStr = BitStringUtils.bytesToBitString((byte[])column.getValue());
                newColumn = new StringColumn(DataType.STRING, bitStr);
                break;
            }
            case BYTES: {
                if (column.getValue() == null) {
                    newColumn = new StringColumn(DataType.STRING, null);
                    break;
                }
                newColumn = new BytesColumn(DataType.BYTES, (byte[])column.getValue());
                break;
            }
            case TIME: {
                newColumn = new TimeColumn(DataType.TIME, column.getString());
                break;
            }
            case DATE: {
                newColumn = new TimeColumn(DataType.DATE, column.getString());
                break;
            }
            case DATETIME: {
                newColumn = new TimeColumn(DataType.DATETIME, column.getString());
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                newColumn = new TimeColumn(DataType.TIMESTAMP_WITH_TIME_ZONE, column.getString());
                break;
            }
            default: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "" + (Object)((Object)column.getType()));
            }
        }
        return newColumn;
    }

    @Override
    public void checkSupported(DataType dataType) {
        switch (dataType) {
            case BOOL: 
            case INTERVAL_DS: 
            case INTERVAL_YM: 
            case UNKNOWN: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type for different database archiving: " + (Object)((Object)dataType));
            }
        }
    }
}

