/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.element.CursorRange;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.DataReadHandler;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIteratorFactory;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReadIterator {
    private static final Logger log = LoggerFactory.getLogger(DataReadIterator.class);
    private KeyReadIterator keyReadIterator = null;
    private TaskMeta taskMeta = null;

    private DataReadIterator() {
    }

    public static DataReadIterator buildDataReadIterator(TaskMeta taskMeta) throws SQLException {
        DataReadIterator dataReadIterator = new DataReadIterator();
        dataReadIterator.keyReadIterator = KeyReadIteratorFactory.getKeyReadIterator(taskMeta.getJobMeta().getSourceAdapter().getDataBaseType());
        dataReadIterator.keyReadIterator.setTableMeta(taskMeta.getJobMeta().getPrimaryTableMeta());
        dataReadIterator.keyReadIterator.setDatasource(taskMeta.getJobMeta().getSourceAdapter());
        dataReadIterator.keyReadIterator.setBatchSize(taskMeta.getJobMeta().getReaderBatchSize());
        dataReadIterator.keyReadIterator.setPrintSqlTrace(taskMeta.getJobMeta().getNeedPrintSqlTrace());
        dataReadIterator.keyReadIterator.setHint(DataReadIterator.getHint(taskMeta.getJobMeta().getSourceAdapter().getDataBaseType()));
        dataReadIterator.taskMeta = taskMeta;
        dataReadIterator.keyReadIterator.init(taskMeta.getPartitionName(), taskMeta.getMinPrimaryKey(), taskMeta.getMaxPrimaryKey(), taskMeta.getCursorPrimaryKey());
        return dataReadIterator;
    }

    public TransRows getNext() throws SQLException {
        TransRows transRows = null;
        while (!this.keyReadIterator.isEnd() && transRows == null) {
            CursorRange cursorRange = this.keyReadIterator.getNext();
            if (cursorRange != null) {
                transRows = DataReadHandler.scan(this.taskMeta, this.taskMeta.getJobMeta().getSourceTableMeta().getName(), this.taskMeta.getJobMeta().getSourceAdapter(), cursorRange.getLowerBound(), cursorRange.getUpperBound(), this.keyReadIterator.getBatchSize(), DataReadIterator.getHint(this.taskMeta.getJobMeta().getSourceAdapter().getDataBaseType()));
                if (transRows == null) continue;
                transRows.setCursorKey(this.keyReadIterator.getLastUpperBound());
                continue;
            }
            log.info(String.format("cursor range is empty, taskMeta = %s", this.taskMeta.toString()));
        }
        return transRows;
    }

    public boolean isEnd() {
        return this.keyReadIterator.isEnd();
    }

    private static String getHint(DataBaseType dbType) {
        switch (dbType) {
            case OB_ORACLE: 
            case OB_MYSQL: {
                return "/*+ READ_CLUSTER(SLAVE), READ_CONSISTENCY(WEAK), NO_REWRITE */";
            }
        }
        return "";
    }
}

