/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.genarator;

import com.oceanbase.tools.migrator.common.element.CursorRange;
import com.oceanbase.tools.migrator.common.enums.ShardingStrategy;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.core.handler.genarator.GeneratorStatus;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIteratorFactory;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(AutoTaskGenerator.class);
    private final JobMeta jobMeta;
    private Queue<TaskMeta> taskBuffer = new LinkedList<TaskMeta>();
    private final Queue<String> partitionQueue;
    private final KeyReadIterator keyReadIterator;

    public AutoTaskGenerator(JobMeta jobMeta) throws Exception {
        this.jobMeta = jobMeta;
        this.partitionQueue = new LinkedList<String>(jobMeta.getJobParameter().getMigratePartitions());
        this.keyReadIterator = KeyReadIteratorFactory.getKeyReadIterator(jobMeta.getSourceAdapter().getDataBaseType());
        this.keyReadIterator.setDatasource(jobMeta.getSourceAdapter());
        this.keyReadIterator.setTableMeta(jobMeta.getPrimaryTableMeta());
        this.keyReadIterator.setBatchSize(jobMeta.getJobParameter().getGeneratorBatchSize());
        this.keyReadIterator.setPrintSqlTrace(jobMeta.getNeedPrintSqlTrace());
        ShardingStrategy shardingStrategy = jobMeta.getJobParameter().getShardingStrategy();
        this.keyReadIterator.setStrategy(shardingStrategy != null ? shardingStrategy : ShardingStrategy.FIXED_LENGTH);
        if (shardingStrategy == ShardingStrategy.MATCH) {
            this.keyReadIterator.setUserDefinedCondition(jobMeta.getJobParameter().getMigrateRule());
        }
        this.keyReadIterator.setPrintSqlTrace(true);
        this.keyReadIterator.setHint(this.getHint());
        this.keyReadIterator.setQueryTimeoutSeconds(86400);
        this.keyReadIterator.init(this.partitionQueue.peek(), null, null, jobMeta.getGenerator().getGeneratorSavePoint());
        this.loadSavePoint();
        jobMeta.getGenerator().setGeneratorStatus(GeneratorStatus.GENERATOR_RUNNING);
        jobMeta.storeTaskGenerator();
        log.info("Init task generator success,strategy = {}", (Object)shardingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMeta generate() {
        if (!this.taskBuffer.isEmpty()) {
            return this.taskBuffer.poll();
        }
        try {
            CursorRange nextRange = this.getNextRange();
            if (nextRange == null) {
                this.jobMeta.getGenerator().setGeneratorStatus(GeneratorStatus.GENERATOR_FINISHED);
                log.info("Task generator is finished,statistic={}", (Object)this.jobMeta.getGenerator());
                TaskMeta taskMeta = null;
                return taskMeta;
            }
            TaskMeta taskMeta = this.createTask(nextRange);
            this.jobMeta.getGenerator().addTaskCount();
            this.jobMeta.getGenerator().setGeneratorSavePoint(nextRange.getUpperBound());
            this.jobMeta.getGenerator().setGeneratorPartitionSavepoint(this.partitionQueue.peek());
            TaskMeta e = taskMeta;
            return e;
        }
        catch (Exception e) {
            this.jobMeta.setError(new JobException(this.jobMeta.getJobId(), e));
            TaskMeta taskMeta = null;
            return taskMeta;
        }
        finally {
            try {
                this.jobMeta.storeTaskGenerator();
            }
            catch (SQLException e) {
                log.warn("Store task generator failed.", (Throwable)e);
            }
        }
    }

    private CursorRange getNextRange() throws Exception {
        while (!this.partitionQueue.isEmpty() || !this.keyReadIterator.isEnd()) {
            CursorRange nextRange;
            if (this.keyReadIterator.isEnd()) {
                String finishedPartitionName = this.partitionQueue.poll();
                log.info("Partition is finished,partitionName={}", (Object)finishedPartitionName);
                if (this.partitionQueue.isEmpty()) {
                    log.info("All partitions have finished, and the task generator will exit.");
                    return null;
                }
                log.info("Next partitionName={}", (Object)this.partitionQueue.peek());
                this.keyReadIterator.init(this.partitionQueue.peek());
            }
            if ((nextRange = this.keyReadIterator.getNext()) == null) continue;
            log.info("Get next range success,lowerBound={},upperBound={}", (Object)nextRange.getLowerBound(), (Object)nextRange.getUpperBound());
            return nextRange.isValid() ? nextRange : null;
        }
        log.info("All partitions have finished, and the task generator will exit.");
        return null;
    }

    private void loadSavePoint() throws Exception {
        String savePointPartition;
        if (this.jobMeta.getGenerator().getGeneratorStatus() != GeneratorStatus.GENERATOR_NEW) {
            this.taskBuffer = new LinkedList<TaskMeta>(this.jobMeta.loadTask());
            log.info("Load save point success,count = {}", (Object)this.taskBuffer.size());
        }
        if (StringUtils.isNotEmpty((String)(savePointPartition = this.jobMeta.getGenerator().getGeneratorPartitionSavepoint()))) {
            while (!savePointPartition.equals(this.partitionQueue.peek()) && !this.partitionQueue.isEmpty()) {
                this.partitionQueue.poll();
            }
            if (this.partitionQueue.isEmpty()) {
                throw new UnExpectedException(String.format("Can not find saved partition in Partition List,saved partition = [%s]", savePointPartition));
            }
        }
    }

    private TaskMeta createTask(CursorRange cursorRange) {
        TaskMeta taskMeta = new TaskMeta();
        taskMeta.setGeneratorId(this.jobMeta.getGenerator().getId());
        taskMeta.setJobMeta(this.jobMeta);
        taskMeta.setTaskIndex(this.jobMeta.getGenerator().getTaskCount().intValue());
        taskMeta.setMinPrimaryKey(cursorRange.getLowerBound());
        taskMeta.setMaxPrimaryKey(cursorRange.getUpperBound());
        taskMeta.setPartitionName(this.partitionQueue.peek());
        try {
            this.jobMeta.storeTaskMeta(taskMeta);
        }
        catch (Exception e) {
            log.warn("Store task failed,index = {}", (Object)taskMeta.getTaskIndex());
        }
        return taskMeta;
    }

    private String getHint() {
        switch (this.jobMeta.getSourceAdapter().getDataBaseType()) {
            case OB_ORACLE: 
            case OB_MYSQL: {
                return "/*+ READ_CLUSTER(SLAVE), READ_CONSISTENCY(WEAK), NO_REWRITE, query_timeout(86400000000) */";
            }
            case MYSQL: {
                return "/*+ MAX_EXECUTION_TIME(86400) */";
            }
        }
        return "";
    }
}

