/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.CursorRange;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.ShardingStrategy;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.RowUtils;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyReadIterator {
    private static final Logger log = LoggerFactory.getLogger(KeyReadIterator.class);
    private DataSourceAdapter datasource = null;
    private Integer queryTimeoutSeconds = null;
    private TableMeta tableMeta = null;
    private ShardingStrategy strategy = ShardingStrategy.FIXED_LENGTH;
    private String partitionName = "";
    private PrimaryKey minKey = null;
    private PrimaryKey maxKey = null;
    private int batchSize = 200;
    private String hint = "";
    private boolean isEnd = false;
    private boolean printSqlTrace = false;
    private String userDefinedCondition = null;
    private long targetCount;
    private PrimaryKey lastUpperBound = null;
    private Long maxExecutionMillis = 0L;
    private Long avgExecutionMillis = 0L;
    private Long totalExecutionMillis = 0L;
    private Long executionCount = 0L;

    public void init(String partitionName) throws SQLException {
        this.init(partitionName, null, null, null);
    }

    public void init(String partitionName, PrimaryKey lowerBound, PrimaryKey upperBound, PrimaryKey savePoint) throws SQLException {
        this.partitionName = partitionName;
        this.minKey = lowerBound;
        this.maxKey = upperBound;
        this.lastUpperBound = savePoint;
        this.isEnd = false;
        if (this.strategy == ShardingStrategy.MATCH) {
            if (this.lastUpperBound == null && this.minKey == null) {
                this.minKey = this.getBound(this.getMinBoundSql());
            }
            this.targetCount = this.lastUpperBound != null ? this.getCount(this.lastUpperBound) : (this.minKey == null ? 0L : this.getCount(this.minKey));
        }
        log.info("Init key iterator success,strategy = {},range = {} -> {},count = {}", new Object[]{this.strategy, this.minKey, this.maxKey, this.targetCount});
    }

    private PrimaryKey getBound(String sql) throws SQLException {
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        PrimaryKey bound = null;
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            ResultSet resultSet = this.executeQuery(ps, sql);
            if (resultSet.next()) {
                Row row = RowUtils.getRow(resultSet, this.datasource.getDataBaseType());
                bound = new PrimaryKey();
                for (int i = 0; i < this.tableMeta.getPrimaryKeyCount(); ++i) {
                    bound.addKeyColumn(row.getColumnList().get(i));
                }
            }
        }
        return bound;
    }

    private Connection getConnection() throws SQLException {
        return this.strategy == ShardingStrategy.FIXED_LENGTH ? this.datasource.getConnectionReadOnly() : this.datasource.getConnectionForDelete();
    }

    public CursorRange getNext() throws SQLException {
        CursorRange cursorRange;
        switch (this.strategy) {
            case MATCH: {
                cursorRange = this.match();
                break;
            }
            default: {
                cursorRange = this.scan();
            }
        }
        boolean bl = this.isEnd = cursorRange == null;
        if (this.isEnd) {
            log.info("Key iterator is finished, range = {} -> {},avg cost={},max cost={},total cost={}", new Object[]{this.minKey, this.maxKey, this.avgExecutionMillis, this.maxExecutionMillis, this.totalExecutionMillis});
        }
        return cursorRange;
    }

    private CursorRange scan() throws SQLException {
        return (CursorRange)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(this.datasource){

            @Override
            public Object run(Connection connection) throws SQLException {
                PrimaryKey lowerBound;
                CursorRange cursorRange = new CursorRange();
                PrimaryKey primaryKey = lowerBound = KeyReadIterator.this.lastUpperBound == null ? KeyReadIterator.this.getBound(KeyReadIterator.this.getMinBoundSql()) : new PrimaryKey(KeyReadIterator.this.lastUpperBound.getPrimaryKeyColumns(), false);
                if (lowerBound == null) {
                    return null;
                }
                PrimaryKey upperBound = KeyReadIterator.this.getBound(KeyReadIterator.this.getUpperBoundSql(lowerBound));
                if (upperBound == null) {
                    upperBound = KeyReadIterator.this.getBound(KeyReadIterator.this.getMaxBoundSql(lowerBound));
                }
                if (upperBound == null) {
                    return null;
                }
                cursorRange.setLowerBound(lowerBound);
                cursorRange.setUpperBound(upperBound);
                KeyReadIterator.this.lastUpperBound = upperBound;
                return cursorRange;
            }
        });
    }

    public CursorRange match() throws SQLException {
        if (this.targetCount <= 0L) {
            log.info("No rows need to be processed.");
            return null;
        }
        if (this.minKey == null && this.lastUpperBound == null) {
            return null;
        }
        PrimaryKey lowerBound = this.lastUpperBound == null ? new PrimaryKey(this.minKey.getPrimaryKeyColumns()) : new PrimaryKey(this.lastUpperBound.getPrimaryKeyColumns(), false);
        CursorRange cursorRange = new CursorRange();
        cursorRange.setLowerBound(lowerBound);
        PrimaryKey upperBound = this.getBound(this.getUpperBoundSql(lowerBound));
        if (upperBound == null) {
            this.targetCount = this.getCount(lowerBound);
            if (this.targetCount < 1L) {
                return null;
            }
            upperBound = this.getBound(this.getUpperBoundSql(lowerBound));
            if (upperBound == null && (upperBound = this.getBound(this.getMaxBoundSql(lowerBound))) == null) {
                return null;
            }
            this.targetCount = 0L;
        } else {
            this.targetCount -= (long)this.getBatchSize();
        }
        cursorRange.setUpperBound(upperBound);
        this.lastUpperBound = upperBound;
        return cursorRange;
    }

    public int getBatchSize() {
        if (this.strategy == ShardingStrategy.MATCH) {
            return this.targetCount > (long)this.batchSize ? this.batchSize : (int)this.targetCount;
        }
        return this.batchSize;
    }

    private Long getCount(PrimaryKey lowerBound) throws SQLException {
        String countSql = this.getCountSql(lowerBound);
        Throwable throwable = null;
        try (Connection conn = this.getConnection();){
            Throwable throwable2;
            PreparedStatement ps;
            block25: {
                Long l;
                block26: {
                    block27: {
                        ps = conn.prepareStatement(countSql);
                        throwable2 = null;
                        ResultSet resultSet = this.executeQuery(ps, countSql);
                        if (!resultSet.next()) break block25;
                        l = resultSet.getLong(1);
                        if (ps == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    ps.close();
                }
                return l;
            }
            try {
                try {
                    try {
                        throw new SQLException("Result not found.");
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (ps != null) {
                        if (throwable2 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            ps.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    private ResultSet executeQuery(PreparedStatement ps, String sql) throws SQLException {
        if (this.printSqlTrace) {
            log.info("Trace sql={}", (Object)sql);
        }
        if (this.queryTimeoutSeconds != null) {
            ps.setQueryTimeout(this.queryTimeoutSeconds);
        }
        long startTime = System.currentTimeMillis();
        ResultSet resultSet = ps.executeQuery();
        long elapsed_time = System.currentTimeMillis() - startTime;
        this.addTotalExecutionMillis(elapsed_time);
        if (this.printSqlTrace) {
            log.info("Execution cost {} millis.", (Object)elapsed_time);
        }
        return resultSet;
    }

    private void addTotalExecutionMillis(Long elapsed_time) {
        this.maxExecutionMillis = Math.max(this.maxExecutionMillis, elapsed_time);
        KeyReadIterator keyReadIterator = this;
        keyReadIterator.totalExecutionMillis = keyReadIterator.totalExecutionMillis + elapsed_time;
        keyReadIterator = this;
        Long l = keyReadIterator.executionCount;
        Long l2 = keyReadIterator.executionCount = Long.valueOf(keyReadIterator.executionCount + 1L);
        this.avgExecutionMillis = this.totalExecutionMillis / this.executionCount;
    }

    public abstract String getMinBoundSql();

    public abstract String getMaxBoundSql(PrimaryKey var1);

    public abstract String getUpperBoundSql(PrimaryKey var1);

    public abstract String getCountSql(PrimaryKey var1);

    public void setDatasource(DataSourceAdapter datasource) {
        this.datasource = datasource;
    }

    public void setQueryTimeoutSeconds(Integer queryTimeoutSeconds) {
        this.queryTimeoutSeconds = queryTimeoutSeconds;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public void setTableMeta(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public void setStrategy(ShardingStrategy strategy) {
        this.strategy = strategy;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public PrimaryKey getMinKey() {
        return this.minKey;
    }

    public void setMinKey(PrimaryKey minKey) {
        this.minKey = minKey;
    }

    public PrimaryKey getMaxKey() {
        return this.maxKey;
    }

    public void setMaxKey(PrimaryKey maxKey) {
        this.maxKey = maxKey;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    public boolean isPrintSqlTrace() {
        return this.printSqlTrace;
    }

    public void setPrintSqlTrace(boolean printSqlTrace) {
        this.printSqlTrace = printSqlTrace;
    }

    public String getUserDefinedCondition() {
        return this.userDefinedCondition;
    }

    public void setUserDefinedCondition(String userDefinedCondition) {
        this.userDefinedCondition = userDefinedCondition;
    }

    public PrimaryKey getLastUpperBound() {
        return this.lastUpperBound;
    }
}

