/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.MysqlKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.ObMysqlKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.ObOracleKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.OracleKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.PostgresKeyReadIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyReadIteratorFactory {
    private static final Logger log = LoggerFactory.getLogger(KeyReadIteratorFactory.class);

    public static KeyReadIterator getKeyReadIterator(DataBaseType dbType) {
        KeyReadIterator keyReadIterator = null;
        switch (dbType) {
            case OB_MYSQL: {
                keyReadIterator = new ObMysqlKeyReadIterator();
                break;
            }
            case MYSQL: {
                keyReadIterator = new MysqlKeyReadIterator();
                break;
            }
            case ORACLE: {
                keyReadIterator = new OracleKeyReadIterator();
                break;
            }
            case OB_ORACLE: {
                keyReadIterator = new ObOracleKeyReadIterator();
                break;
            }
            case POSTGRESQL: {
                keyReadIterator = new PostgresKeyReadIterator();
                break;
            }
            default: {
                log.warn("Invalid database type={}", (Object)dbType);
            }
        }
        return keyReadIterator;
    }
}

