/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.MysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.MySqlUtils;
import com.oceanbase.tools.migrator.sql.SqlUtils;

public class MysqlKeyReadIterator
extends KeyReadIterator {
    @Override
    public String getMinBoundSql() {
        MysqlSqlBuilder builder = new MysqlSqlBuilder();
        builder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        builder.setTableName(this.getTableMeta().getName());
        builder.setHint(this.getHint());
        builder.setPartitionName(this.getPartitionName());
        builder.addPrimaryKeyCondition(MySqlUtils.getMinKeyCondition(this.getTableMeta(), this.getMinKey()));
        builder.addPrimaryKeyCondition(MySqlUtils.getMaxKeyCondition(this.getTableMeta(), this.getMaxKey()));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setLimit(1);
        builder.setShardKeyName(this.getTableMeta().getShardKeyName());
        return builder.getReadDataSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        MysqlSqlBuilder builder = new MysqlSqlBuilder();
        builder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        builder.setTableName(this.getTableMeta().getName());
        builder.setPartitionName(this.getPartitionName());
        builder.setHint(this.getHint());
        builder.addPrimaryKeyCondition(MySqlUtils.getMinKeyCondition(this.getTableMeta(), lowerBound));
        builder.addPrimaryKeyCondition(MySqlUtils.getMaxKeyCondition(this.getTableMeta(), this.getMaxKey()));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        builder.setOrderByMethod(OrderByMethod.DESC);
        builder.setLimit(1);
        builder.setShardKeyName(this.getTableMeta().getShardKeyName());
        return builder.getReadDataSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        MysqlSqlBuilder builder = new MysqlSqlBuilder();
        builder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        builder.setTableName(this.getTableMeta().getName());
        builder.setPartitionName(this.getPartitionName());
        builder.setHint(this.getHint());
        builder.addPrimaryKeyCondition(MySqlUtils.getMinKeyCondition(this.getTableMeta(), lowerBound));
        builder.addPrimaryKeyCondition(MySqlUtils.getMaxKeyCondition(this.getTableMeta(), this.getMaxKey()));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setOffset(this.getBatchSize() - 1);
        builder.setLimit(1);
        builder.setShardKeyName(this.getTableMeta().getShardKeyName());
        return builder.getReadDataSql();
    }

    @Override
    public String getCountSql(PrimaryKey lowerBound) {
        ObMysqlSqlBuilder builder = new ObMysqlSqlBuilder();
        builder.setTableName(this.getTableMeta().getName());
        builder.setPartitionName(this.getPartitionName());
        builder.setHint(this.getHint());
        builder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.getTableMeta(), lowerBound));
        builder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.getTableMeta(), this.getMaxKey()));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        return builder.getReadCountSql();
    }
}

