/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.ObOracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.SqlUtils;

public class ObOracleKeyReadIterator
extends KeyReadIterator {
    @Override
    public String getMinBoundSql() {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        obOracleSqlBuilder.setHint(this.getHint());
        obOracleSqlBuilder.setTableOwner(this.getTableMeta().getSchema());
        obOracleSqlBuilder.setTableName(this.getTableMeta().getName());
        obOracleSqlBuilder.setPartitionName(this.getPartitionName());
        obOracleSqlBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.getTableMeta(), this.getMinKey()));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.getTableMeta(), this.getMaxKey()));
        obOracleSqlBuilder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        obOracleSqlBuilder.setOrderByMethod(OrderByMethod.ASC);
        obOracleSqlBuilder.setBatchSize(1);
        return obOracleSqlBuilder.getBoundSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        obOracleSqlBuilder.setTableOwner(this.getTableMeta().getSchema());
        obOracleSqlBuilder.setHint(this.getHint());
        obOracleSqlBuilder.setTableName(this.getTableMeta().getName());
        obOracleSqlBuilder.setPartitionName(this.getPartitionName());
        obOracleSqlBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.getTableMeta(), lowerBound));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.getTableMeta(), this.getMaxKey()));
        obOracleSqlBuilder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        obOracleSqlBuilder.setOrderByMethod(OrderByMethod.DESC);
        obOracleSqlBuilder.setBatchSize(1);
        return obOracleSqlBuilder.getBoundSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        obOracleSqlBuilder.setTableOwner(this.getTableMeta().getSchema());
        obOracleSqlBuilder.setTableName(this.getTableMeta().getName());
        obOracleSqlBuilder.setHint(this.getHint());
        obOracleSqlBuilder.setPartitionName(this.getPartitionName());
        obOracleSqlBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.getTableMeta(), lowerBound));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.getTableMeta(), this.getMaxKey()));
        obOracleSqlBuilder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        obOracleSqlBuilder.setOrderByMethod(OrderByMethod.ASC);
        obOracleSqlBuilder.setBatchSize(this.getBatchSize());
        return obOracleSqlBuilder.getBoundSql();
    }

    @Override
    public String getCountSql(PrimaryKey lowerBound) {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setTableOwner(this.getTableMeta().getSchema());
        obOracleSqlBuilder.setTableName(this.getTableMeta().getName());
        obOracleSqlBuilder.setHint(this.getHint());
        obOracleSqlBuilder.setPartitionName(this.getPartitionName());
        obOracleSqlBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.getTableMeta(), lowerBound));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.getTableMeta(), this.getMaxKey()));
        return obOracleSqlBuilder.getReadCountSql();
    }
}

