/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleKeyReadIterator
extends KeyReadIterator {
    private static final Logger log = LoggerFactory.getLogger(OracleKeyReadIterator.class);

    @Override
    public String getMinBoundSql() {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        oracleBuilder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        oracleBuilder.setTableOwner(this.getTableMeta().getSchema());
        oracleBuilder.setTableName(this.getTableMeta().getName());
        oracleBuilder.setPartitionName(this.getPartitionName());
        oracleBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(this.getTableMeta(), this.getMinKey()));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(this.getTableMeta(), this.getMaxKey()));
        oracleBuilder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        oracleBuilder.setOrderByMethod(OrderByMethod.ASC);
        oracleBuilder.setBatchSize(1);
        return oracleBuilder.getBoundSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        oracleBuilder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        oracleBuilder.setTableOwner(this.getTableMeta().getSchema());
        oracleBuilder.setTableName(this.getTableMeta().getName());
        oracleBuilder.setPartitionName(this.getPartitionName());
        oracleBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(this.getTableMeta(), lowerBound));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(this.getTableMeta(), this.getMaxKey()));
        oracleBuilder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        oracleBuilder.setOrderByMethod(OrderByMethod.DESC);
        oracleBuilder.setBatchSize(1);
        return oracleBuilder.getBoundSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        oracleBuilder.setSelectColumns(this.getTableMeta().getPkColumnListStr());
        oracleBuilder.setTableOwner(this.getTableMeta().getSchema());
        oracleBuilder.setTableName(this.getTableMeta().getName());
        oracleBuilder.setPartitionName(this.getPartitionName());
        oracleBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(this.getTableMeta(), lowerBound));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(this.getTableMeta(), this.getMaxKey()));
        oracleBuilder.setOrderByColumns(this.getTableMeta().getShardKeyColumns());
        oracleBuilder.setOrderByMethod(OrderByMethod.ASC);
        oracleBuilder.setBatchSize(this.getBatchSize());
        return oracleBuilder.getBoundSql();
    }

    @Override
    public String getCountSql(PrimaryKey lowerBound) {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        oracleBuilder.setTableOwner(this.getTableMeta().getSchema());
        oracleBuilder.setTableName(this.getTableMeta().getName());
        oracleBuilder.setPartitionName(this.getPartitionName());
        oracleBuilder.addUserDefinedCondition(this.getUserDefinedCondition());
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.getTableMeta(), lowerBound));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.getTableMeta(), this.getMaxKey()));
        return oracleBuilder.getReadCountSql();
    }
}

