/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel;

import com.oceanbase.tools.migrator.common.exception.JobInterruptedException;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractTunnel<T> {
    private AtomicLong producerCount = new AtomicLong(0L);
    private AtomicLong consumerCount = new AtomicLong(0L);
    protected JobMeta jobMeta = null;

    public AbstractTunnel(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public void incProducer() {
        this.producerCount.incrementAndGet();
    }

    public void decProducer() {
        this.producerCount.decrementAndGet();
    }

    public boolean isProducerEmpty() {
        return this.producerCount.get() == 0L;
    }

    public void incConsumer() {
        this.consumerCount.incrementAndGet();
    }

    public void decConsumer() {
        this.consumerCount.decrementAndGet();
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public T take() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new JobInterruptedException("job is interrupted, stop running");
        }
        return this.takeInternal();
    }

    public void put(T t) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new JobInterruptedException("job is interrupted, stop running");
        }
        this.putInternal(t);
    }

    public abstract T takeInternal() throws InterruptedException;

    public abstract void putInternal(T var1) throws InterruptedException;

    public void report() {
    }
}

