/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel;

import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.tunnel.TransRowsTunnel;
import com.oceanbase.tools.migrator.core.tunnel.limiter.DataSizeRateLimiter;
import com.oceanbase.tools.migrator.core.tunnel.limiter.RowRateLimiter;

public class ConvertTunnel
extends TransRowsTunnel {
    public ConvertTunnel(JobMeta jobMeta) {
        super(jobMeta);
        int sourceReadSizeLimit = Math.min(jobMeta.getSourceCluster().getAvgReadSizeLimit(), jobMeta.getSourceTenant().getAvgReadSizeLimit());
        int targetReadSizeLimit = Math.min(jobMeta.getTargetCluster().getAvgReadSizeLimit(), jobMeta.getTargetTenant().getAvgReadSizeLimit());
        this.setPutRowRateLimiter(new RowRateLimiter(jobMeta, jobMeta.getSourceTableMeta().getReadRowCountLimit(), String.format("ReadRowLimiter(%s)", jobMeta.getSourceTableMeta().getName())));
        this.setPutSizeRateLimiter(new DataSizeRateLimiter(jobMeta, sourceReadSizeLimit, String.format("ReadDataSizeLimiter(%s)", jobMeta.getSourceCluster().getClusterName())));
        this.setTakeSizeRateLimiter(new DataSizeRateLimiter(jobMeta, targetReadSizeLimit, String.format("ReadDataSizeLimiter(%s)", jobMeta.getTargetCluster().getClusterName())));
    }

    @Override
    public void updateRateLimit() {
        int sourceReadSizeLimit = Math.min(this.jobMeta.getSourceCluster().getAvgReadSizeLimit(), this.jobMeta.getSourceTenant().getAvgReadSizeLimit());
        int targetReadSizeLimit = Math.min(this.jobMeta.getTargetCluster().getAvgReadSizeLimit(), this.jobMeta.getTargetTenant().getAvgReadSizeLimit());
        this.getPutRowRateLimiter().updateRate(this.jobMeta.getSourceTableMeta().getReadRowCountLimit());
        this.getPutSizeRateLimiter().updateRate(sourceReadSizeLimit);
        this.getTakeSizeRateLimiter().updateRate(targetReadSizeLimit);
    }
}

