/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel.limiter;

import com.google.common.util.concurrent.RateLimiter;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRateLimiter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRateLimiter.class);
    protected JobMeta jobMeta = null;
    protected RateLimiter rateLimiter = null;
    protected int rate = 0;
    private String limiterName;

    protected AbstractRateLimiter(JobMeta jobMeta, int defaultRate, String limiterName) {
        if (defaultRate < 0) {
            throw new UnExpectedException(String.format("invalid rate, rate = %d", defaultRate));
        }
        this.limiterName = limiterName;
        this.jobMeta = jobMeta;
        this.rate = defaultRate;
        if (defaultRate > 0) {
            this.rateLimiter = RateLimiter.create((double)defaultRate);
        }
    }

    public void acquire(int permits) {
        double sleepSeconds;
        while (this.rate == 0) {
            try {
                if (this.jobMeta.isToStop()) break;
                int sleepTime = 10;
                log.info("{} Current Rate Limit is active, Sleep {} S", (Object)this.limiterName, (Object)sleepTime);
                Thread.sleep((long)sleepTime * 1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.rateLimiter != null && (sleepSeconds = this.rateLimiter.acquire(permits)) > 1.0) {
            log.info("{} Reach Rate Limit And Sleep {} S", (Object)this.limiterName, (Object)sleepSeconds);
        }
    }

    public void updateRate(int rate) {
        this.rate = rate;
        if (rate > 0) {
            if (this.rateLimiter != null) {
                this.rateLimiter.setRate((double)rate);
            } else {
                this.rateLimiter = RateLimiter.create((double)rate);
            }
        }
    }
}

