/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.writer;

import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.core.writer.IDataWriter;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataWriter
implements IDataWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataWriter.class);

    @Override
    public void write(TransRows rows) throws SQLException {
        if (rows.getRowCount() == 0) {
            return;
        }
        DataSourceAdapter targetDs = rows.getOwnerTaskMeta().getJobMeta().getTargetAdapter();
        HandlerUtils.runWithRetry(() -> {
            for (int i = rows.getBatchRowsCount() - 1; i >= 0; --i) {
                try (Connection conn = targetDs.getConnectionForWrite();){
                    this.writeBatchRows(conn, rows.getOwnerTaskMeta(), rows.getBatchRows(i));
                    continue;
                }
            }
            return null;
        });
    }

    protected void writeBatchRows(Connection conn, TaskMeta taskMeta, BatchRows batchRows) throws SQLException {
        List<BatchRows> groupByPartition = HandlerUtils.groupBatchRowByPartition(batchRows);
        MigrationInsertAction insertStrategy = batchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta().getJobParameter().getMigrationInsertAction();
        int writeBatchSize = batchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta().getWriterBatchSize();
        for (BatchRows group : groupByPartition) {
            if (group.getRows().isEmpty()) continue;
            if (insertStrategy == MigrationInsertAction.INSERT_DUPLICATE_UPDATE) {
                this.writeBatchRowsByDuplicateUpdate(conn, taskMeta, group.getRows(), writeBatchSize);
                continue;
            }
            try {
                this.writeBatchRows(conn, taskMeta, group.getRows(), writeBatchSize);
            }
            catch (SQLException e) {
                if (this.getDuplicateErrorCodes().contains(e.getErrorCode())) {
                    this.writeBatchRowsBySingleInsert(conn, taskMeta, group.getRows(), insertStrategy);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void writeBatchRows(Connection conn, TaskMeta taskMeta, List<Row> rows, long writeBatchSize) throws SQLException {
        String writeSql = this.getWriteSql(taskMeta.getJobMeta().getTargetTableMeta());
        try (PreparedStatement preparedStatement = conn.prepareStatement(writeSql);){
            for (int i = 0; i < rows.size(); ++i) {
                SqlUtils.setPreparedStatement(preparedStatement, rows.get(i));
                preparedStatement.addBatch();
                if ((long)(i + 1) % writeBatchSize != 0L && i != rows.size() - 1) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
    }

    protected void writeBatchRowsBySingleInsert(Connection conn, TaskMeta taskMeta, List<Row> rows, MigrationInsertAction insertStrategy) throws SQLException {
        String writeSql = this.getWriteSql(taskMeta.getJobMeta().getTargetTableMeta());
        int duplicatedCount = 0;
        try (PreparedStatement preparedStatement = conn.prepareStatement(writeSql);){
            int singleInsertTotal = rows.size();
            for (Row row : rows) {
                SqlUtils.setPreparedStatement(preparedStatement, row);
                try {
                    preparedStatement.execute();
                }
                catch (SQLException e) {
                    if (this.getDuplicateErrorCodes().contains(e.getErrorCode()) && insertStrategy == MigrationInsertAction.INSERT_IGNORE) {
                        log.info("Duplicate key found,table={},primaryKey={}", (Object)taskMeta.getJobMeta().getTargetTableMeta().getName(), (Object)row.getPrimaryKey());
                        ++duplicatedCount;
                        taskMeta.getJobMeta().getJobStat().addUnMatchedRowCount(1L);
                    }
                    throw e;
                }
                log.info("Try single insert lines,count={},duplicatedCount={}]", (Object)singleInsertTotal, (Object)duplicatedCount);
            }
        }
    }

    protected void writeBatchRowsByDuplicateUpdate(Connection conn, TaskMeta taskMeta, List<Row> rows, long writeBatchSize) throws SQLException {
        String writeSql = this.generateInsertOnDuplicatedUpdateStmt(taskMeta.getJobMeta().getTargetTableMeta());
        if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
            log.info("getBatchWriteSqlByUpdate = " + writeSql);
        }
        try (PreparedStatement preparedStatement = conn.prepareStatement(writeSql);){
            for (int i = 0; i < rows.size(); ++i) {
                SqlUtils.setPreparedStatement(preparedStatement, rows.get(i));
                preparedStatement.addBatch();
                if ((long)(i + 1) % writeBatchSize != 0L && i != rows.size() - 1) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
    }

    public String getColumnListString(TableMeta tableMeta) {
        List columnNames = tableMeta.getColumnMetas().stream().map(col -> SqlUtils.quoteIdentifier(col.getName(), tableMeta.getDataBaseType())).collect(Collectors.toList());
        return String.join((CharSequence)",", columnNames);
    }

    protected abstract Set<Integer> getDuplicateErrorCodes();

    protected abstract String getWriteSql(TableMeta var1);

    protected abstract String generateInsertOnDuplicatedUpdateStmt(TableMeta var1);
}

