/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.writer;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.writer.IDataWriter;
import com.oceanbase.tools.migrator.core.writer.MySQLDataWriter;
import com.oceanbase.tools.migrator.core.writer.OracleDataWriter;
import com.oceanbase.tools.migrator.core.writer.PostgresDataWriter;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataWriterUtil {
    private static final Map<DataBaseType, IDataWriter> dataWriterMap = new ConcurrentHashMap<DataBaseType, IDataWriter>();

    public static void write(TransRows rows) throws SQLException {
        DataWriterUtil.getDataWriter(rows.getOwnerTaskMeta().getJobMeta().getTargetAdapter().getDataBaseType()).write(rows);
    }

    private static IDataWriter getDataWriter(DataBaseType dbType) {
        return dataWriterMap.computeIfAbsent(dbType, k -> {
            if (k.isOracle()) {
                return new OracleDataWriter();
            }
            if (k.isMySQL()) {
                return new MySQLDataWriter();
            }
            if (k.isPostgres()) {
                return new PostgresDataWriter();
            }
            throw new IllegalArgumentException(String.format("Unsupported database,type=%s", k));
        });
    }
}

