/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.writer;

import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.writer.AbstractDataWriter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataWriter
extends AbstractDataWriter {
    private static final Logger log = LoggerFactory.getLogger(MySQLDataWriter.class);
    private static final int DUPLICATE_ENTRY_CODE = 1062;
    private static final int VERSION_NOT_SUPPORT = 1235;

    @Override
    protected String generateInsertOnDuplicatedUpdateStmt(TableMeta tgtTable) {
        String writeSql = MySQLDataWriter.isFullPKTable(tgtTable) != false ? this.getWriteSqlReplaceMode(tgtTable) : this.getWriteSqlDuplicateUpdateMode(tgtTable);
        return writeSql;
    }

    private static Boolean isFullPKTable(TableMeta tableMeta) {
        boolean isFullPkTable = true;
        for (ColumnMeta columnMeta : tableMeta.getColumnMetas()) {
            if (columnMeta.isShardKeyColumn()) continue;
            isFullPkTable = false;
            break;
        }
        return isFullPkTable;
    }

    private String getWriteSqlReplaceMode(TableMeta tgtTable) {
        String writeSqlTmpl = "REPLACE INTO %s (%s) VALUES %s";
        String columnList = this.getColumnListString(tgtTable);
        String columnRefList = SqlUtils.getColumnRefList(tgtTable.getColumnMetas().size());
        return String.format(writeSqlTmpl, SqlUtils.quoteMySQLIdentifier(tgtTable.getName()), columnList, columnRefList);
    }

    private String getWriteSqlDuplicateUpdateMode(TableMeta tgtTable) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(SqlUtils.quoteMySQLIdentifier(tgtTable.getSchema()));
        sb.append(".");
        sb.append(SqlUtils.quoteMySQLIdentifier(tgtTable.getName()));
        sb.append(" (");
        sb.append(this.getColumnListString(tgtTable));
        sb.append(") VALUES ");
        sb.append(SqlUtils.getColumnRefList(tgtTable.getColumnMetas().size()));
        sb.append(" ON DUPLICATE KEY UPDATE ");
        sb.append(SqlUtils.getUpdateListString(tgtTable));
        return sb.toString();
    }

    @Override
    protected Set<Integer> getDuplicateErrorCodes() {
        HashSet<Integer> errorCodes = new HashSet<Integer>();
        errorCodes.add(1062);
        return errorCodes;
    }

    @Override
    protected String getWriteSql(TableMeta tgtTable) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(SqlUtils.quoteMySQLIdentifier(tgtTable.getSchema()));
        sb.append(".");
        sb.append(SqlUtils.quoteMySQLIdentifier(tgtTable.getName()));
        sb.append(" (");
        sb.append(this.getColumnListString(tgtTable));
        sb.append(") VALUES ");
        sb.append(SqlUtils.getColumnRefList(tgtTable.getColumnMetas().size()));
        return sb.toString();
    }
}

