/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.writer;

import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.writer.AbstractDataWriter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataWriter
extends AbstractDataWriter {
    private static final Logger log = LoggerFactory.getLogger(OracleDataWriter.class);
    private static final int DUPLICATE_ENTRY_CODE = 1;

    @Override
    protected Set<Integer> getDuplicateErrorCodes() {
        HashSet<Integer> errorCodes = new HashSet<Integer>();
        errorCodes.add(1);
        return errorCodes;
    }

    @Override
    protected String getWriteSql(TableMeta tgtTable) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(SqlUtils.quoteOracleIdentifier(tgtTable.getSchema()));
        sb.append(".");
        sb.append(SqlUtils.quoteOracleIdentifier(tgtTable.getName()));
        sb.append(" (");
        sb.append(this.getColumnListString(tgtTable));
        sb.append(") VALUES ");
        sb.append(SqlUtils.getColumnRefList(tgtTable.getColumnMetas().size()));
        return sb.toString();
    }

    @Override
    protected String generateInsertOnDuplicatedUpdateStmt(TableMeta tgtTable) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO ").append(SqlUtils.quoteOracleIdentifier(tgtTable.getSchema())).append(".").append(SqlUtils.quoteOracleIdentifier(tgtTable.getName())).append(" t ").append("USING (SELECT ");
        for (i = 0; i < tgtTable.getColumnMetas().size(); ++i) {
            sb.append("? AS ").append(SqlUtils.quoteOracleIdentifier(tgtTable.getColumnMetas().get(i).getName()));
            if (i >= tgtTable.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(" FROM DUAL ) s ON (");
        for (i = 0; i < tgtTable.getShardKeyColumns().size(); ++i) {
            sb.append(" t.").append(SqlUtils.quoteOracleIdentifier(tgtTable.getShardKeyColumns().get(i).getName()));
            sb.append(" = s.").append(SqlUtils.quoteOracleIdentifier(tgtTable.getShardKeyColumns().get(i).getName()));
            if (i >= tgtTable.getShardKeyColumns().size() - 1) continue;
            sb.append(" AND ");
        }
        sb.append(") WHEN MATCHED THEN UPDATE SET ");
        sb.append(tgtTable.getColumnMetas().stream().filter(col -> !col.isShardKeyColumn()).map(col -> " t." + col.getName() + " = s." + SqlUtils.quoteOracleIdentifier(col.getName())).collect(Collectors.joining(",")));
        sb.append(" WHEN NOT MATCHED THEN INSERT (");
        for (i = 0; i < tgtTable.getColumnMetas().size(); ++i) {
            sb.append(SqlUtils.quoteOracleIdentifier(tgtTable.getColumnMetas().get(i).getName()));
            if (i >= tgtTable.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(") ").append("VALUES (");
        for (i = 0; i < tgtTable.getColumnMetas().size(); ++i) {
            sb.append("s.").append(SqlUtils.quoteOracleIdentifier(tgtTable.getColumnMetas().get(i).getName()));
            if (i >= tgtTable.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

