/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.writer;

import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.writer.AbstractDataWriter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDataWriter
extends AbstractDataWriter {
    private static final Logger log = LoggerFactory.getLogger(PostgresDataWriter.class);
    private static final int DUPLICATE_ENTRY_CODE = 0;

    @Override
    protected Set<Integer> getDuplicateErrorCodes() {
        HashSet<Integer> errorCodes = new HashSet<Integer>();
        errorCodes.add(0);
        return errorCodes;
    }

    @Override
    protected String getWriteSql(TableMeta tgtTable) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(SqlUtils.quotePostgresIdentifier(tgtTable.getSchema()));
        sb.append(".");
        sb.append(SqlUtils.quotePostgresIdentifier(tgtTable.getName()));
        sb.append(" (");
        sb.append(this.getColumnListString(tgtTable));
        sb.append(") VALUES ");
        sb.append(SqlUtils.getColumnRefList(tgtTable.getColumnMetas().size()));
        return sb.toString();
    }

    @Override
    protected String generateInsertOnDuplicatedUpdateStmt(TableMeta tgtTable) {
        int columnCount = tgtTable.getColumnMetas().size();
        StringBuilder sb = new StringBuilder();
        sb.append("insert into");
        sb.append(" ").append(tgtTable.getName());
        sb.append(" ").append("(").append(tgtTable.getColumnListStr()).append(")");
        sb.append(" ").append("values");
        sb.append(" ").append(SqlUtils.getColumnRefList(columnCount));
        sb.append(" ").append("on conflict");
        sb.append(" ").append("(").append(tgtTable.getPkColumnListStr()).append(")");
        sb.append(" ").append("do update set");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < columnCount; ++i) {
            ColumnMeta columnMeta = tgtTable.getColumnMetas().get(i);
            builder.append(columnMeta.getName()).append("= excluded.").append(columnMeta.getName());
            if (i >= columnCount - 1) continue;
            builder.append(",");
        }
        sb.append(" ").append((CharSequence)builder);
        return sb.toString();
    }
}

