/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MysqlDataSourceAdapter
extends AbstractDataSourceAdapter {
    private DruidDataSource druidDataSource;
    private String dbVersion;

    public MysqlDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        if (StringUtils.isNotEmpty((String)conf.getPassword())) {
            properties.setProperty("password", conf.getPassword());
        }
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:mysql://%s:%d/%s", conf.getIp(), conf.getPort(), conf.getDatabaseName());
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
        properties.setProperty("driverClassName", "com.mysql.jdbc.Driver");
        properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
        properties.setProperty("validationQuery", "select 1;");
        properties.setProperty("validationQueryTimeout", "5");
        properties.setProperty("removeAbandoned", "true");
        properties.setProperty("removeAbandonedTimeout", "1800");
        properties.setProperty("logAbandoned", "true");
        this.druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        this.druidDataSource.setQueryTimeout(conf.getQueryTimeout());
        this.druidDataSource.setSocketTimeout(Integer.MAX_VALUE);
        this.druidDataSource.setConnectionErrorRetryAttempts(3);
        this.druidDataSource.setBreakAfterAcquireFailure(true);
        this.druidDataSource.setMaxWait(60000L);
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getBackendConnection() throws SQLException {
        return this.getConnection();
    }

    @Override
    public String getDbVersion() throws SQLException {
        if (StringUtils.isEmpty((String)this.dbVersion)) {
            try (Connection conn = this.getConnectionReadOnly();){
                PreparedStatement ps = conn.prepareStatement("select version()");
                ResultSet resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    this.dbVersion = resultSet.getString(1);
                }
            }
        }
        return this.dbVersion;
    }

    @Override
    public void closeDataSource() {
        super.closeDataSource();
        if (this.druidDataSource != null) {
            this.druidDataSource.close();
        }
    }
}

