/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.util.OBVersionUtil;
import com.oceanbase.tools.migrator.datasource.AbstractObDataSourceAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMySQLModeDataSourceAdapter
extends AbstractObDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(ObMySQLModeDataSourceAdapter.class);
    private static final int CPU_PERCENT_THRESHOLD = 25;
    private DataSourceInfo dataSourceInfo;
    private Map<String, TableEntry> tableEntryMap = new ConcurrentHashMap<String, TableEntry>();

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowWrite(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowDelete(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ObMySQLModeDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        this.dataSourceInfo = conf;
        log.info(String.format("begin to init datasource OBMYSQL: %s", conf.getDataSourceName()));
        if (conf.getFullUserName() == null || conf.getDatabaseName() == null) {
            log.warn(String.format("missing configure for oceanbase dataSource, conf=%s", conf));
            return;
        }
        this.dataSource = this.configDataSourceByObProxy(conf);
        this.obVersion = this.getDbVersion();
        if (StringUtils.isEmpty((String)this.obVersion)) {
            log.error("Get OB version failed.");
            throw new UnExpectedException("Get OB version failed.");
        }
        try (Connection conn = this.getConnectionReadOnly();){
            String currentTenantName = this.getCurrentTenantName(conn);
            this.dataSourceInfo.setTenantName(currentTenantName);
            this.dataSourceInfo.setTenantId(this.getTenantId(currentTenantName, conn));
            if (StringUtils.isEmpty((String)this.dataSourceInfo.getClusterName())) {
                this.dataSourceInfo.setClusterName(this.getClusterName(conn));
            }
        }
        if (StringUtils.isNotEmpty((String)conf.getSysUser())) {
            this.sysDataSource = this.configSysDataSourceByObProxy(conf);
        }
        if (this.sysDataSource == null) {
            log.info("No Sys tenant user or init sys datasource failed.");
        }
        this.setSleepTime(this.dataSourceInfo.getSleepTime());
    }

    @Override
    public TableSizeInfo getSourceTableSizeInfo(String tableName) throws SQLException {
        try (Connection conn = this.getConnection();){
            TableSizeInfo tableSizeInfo = this.queryTableRowCount(conn, tableName, this.dataSourceInfo.getDatabaseName());
            return tableSizeInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableSizeInfo queryTableRowCount(Connection connection, String tableName, String dbName) throws SQLException {
        TableSizeInfo tableSizeInfo = new TableSizeInfo();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement("select TABLE_ROWS, DATA_LENGTH from `information_schema`.`tables` where table_schema= ?  and table_name= ?");
            ps.setString(1, this.getSchema());
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                tableSizeInfo.setTableRowCount(rs.getLong("TABLE_ROWS"));
                tableSizeInfo.setDataSize(rs.getLong("DATA_LENGTH"));
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)ps);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)ps);
        return tableSizeInfo;
    }

    protected String getCurrentTenantName(Connection connection) throws SQLException {
        PreparedStatement ps = connection.prepareStatement("show tenant");
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    protected String getTenantMemQuerySql() {
        if (OBVersionUtil.isGreaterThanOB4X(this.obVersion)) {
            return String.format("SELECT 1 FROM oceanbase.gv$ob_memstore where tenant_id = '%s' AND (MEMSTORE_USED >= FREEZE_TRIGGER * 1.05);", this.dataSourceInfo.getTenantId());
        }
        return String.format("SELECT 1 FROM oceanbase.gv$memstore where tenant_id = '%s' AND (TOTAL >= FREEZE_TRIGGER * 1.05)", this.dataSourceInfo.getTenantId());
    }
}

