/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class PostgresDataSourceAdapter
extends AbstractDataSourceAdapter {
    private DruidDataSource druidDataSource;

    public PostgresDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        if (StringUtils.isNotEmpty((String)conf.getPassword())) {
            properties.setProperty("password", conf.getPassword());
        }
        String url = conf.getJdbcUrl();
        properties.setProperty("url", url);
        properties.setProperty("driverClassName", "org.postgresql.Driver");
        this.druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        this.druidDataSource.setQueryTimeout(conf.getQueryTimeout());
        this.druidDataSource.setSocketTimeout(conf.getQueryTimeout() * 1000);
        this.druidDataSource.setConnectionErrorRetryAttempts(3);
        this.druidDataSource.setBreakAfterAcquireFailure(true);
        this.druidDataSource.setMaxWait(60000L);
    }

    @Override
    public String getDbVersion() throws SQLException {
        throw new UnsupportedOperationException("Get db version is unsupported operation for postgres.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getBackendConnection() throws SQLException {
        return this.getConnection();
    }
}

