/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.job;

import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.core.runner.ConvertDataRunner;
import com.oceanbase.tools.migrator.core.runner.ReadDataFromTaskRunner;
import com.oceanbase.tools.migrator.core.runner.WriteDataFromRecordRunner;
import com.oceanbase.tools.migrator.core.tunnel.ConvertTunnel;
import com.oceanbase.tools.migrator.core.tunnel.WriteTunnel;
import com.oceanbase.tools.migrator.job.AbstractJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(RollbackJob.class);
    private WriteTunnel writeTunnel = null;
    private ConvertTunnel convertTunnel = null;

    @Override
    void processJobInternal() {
        log.info("Rollback job set MigrationInsertAction INSERT_IGNORE");
        this.jobMeta.getJobParameter().setMigrationInsertAction(MigrationInsertAction.INSERT_IGNORE);
        this.writeTunnel = new WriteTunnel(this.jobMeta);
        this.convertTunnel = new ConvertTunnel(this.jobMeta);
        if (this.getJobMeta().needDataConvert()) {
            int i;
            for (i = 0; i < this.jobMeta.getReaderTaskCount(); ++i) {
                ReadDataFromTaskRunner readDataFromTaskRunner = new ReadDataFromTaskRunner();
                readDataFromTaskRunner.setReadTunnel(this.taskTunnel);
                readDataFromTaskRunner.setWriteTunnel(this.convertTunnel);
                readDataFromTaskRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackReader-" + i);
                this.childRunners.add(this.getExecutorService().submit(readDataFromTaskRunner));
            }
            for (i = 0; i < this.jobMeta.getReaderTaskCount(); ++i) {
                ConvertDataRunner convertDataRunner = new ConvertDataRunner();
                convertDataRunner.setReadTunnel(this.convertTunnel);
                convertDataRunner.setWriteTunnel(this.writeTunnel);
                convertDataRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackConvert-" + i);
                this.childRunners.add(this.getExecutorService().submit(convertDataRunner));
            }
            for (i = 0; i < this.jobMeta.getWriterTaskCount(); ++i) {
                WriteDataFromRecordRunner writeDataFromRecordRunner = new WriteDataFromRecordRunner();
                writeDataFromRecordRunner.setReadTunnel(this.writeTunnel);
                writeDataFromRecordRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackWriter-" + i);
                this.childRunners.add(this.getExecutorService().submit(writeDataFromRecordRunner));
            }
        } else {
            int i;
            for (i = 0; i < this.jobMeta.getReaderTaskCount(); ++i) {
                ReadDataFromTaskRunner readDataFromTaskRunner = new ReadDataFromTaskRunner();
                readDataFromTaskRunner.setReadTunnel(this.taskTunnel);
                readDataFromTaskRunner.setWriteTunnel(this.writeTunnel);
                readDataFromTaskRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackReader-" + i);
                this.childRunners.add(this.getExecutorService().submit(readDataFromTaskRunner));
            }
            for (i = 0; i < this.jobMeta.getWriterTaskCount(); ++i) {
                WriteDataFromRecordRunner writeDataFromRecordRunner = new WriteDataFromRecordRunner();
                writeDataFromRecordRunner.setReadTunnel(this.writeTunnel);
                writeDataFromRecordRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackWriter-" + i);
                this.childRunners.add(this.getExecutorService().submit(writeDataFromRecordRunner));
            }
        }
    }

    @Override
    void doTimerTask() {
        this.writeTunnel.report();
        this.writeTunnel.updateRateLimit();
    }
}

