/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.partition;

import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.partition.IPartitionService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLPartitionService
implements IPartitionService {
    private static final Logger log = LoggerFactory.getLogger(MySQLPartitionService.class);

    @Override
    public List<String> getAffectedPartitions(DataSourceAdapter datasource, TableMeta tableMeta, String condition) throws SQLException {
        List<Object> affectedPartitions = new LinkedList();
        StringBuilder sb = new StringBuilder();
        sb.append("EXPLAIN SELECT * FROM ");
        sb.append("`").append(tableMeta.getSchema()).append("`");
        sb.append(".`").append(tableMeta.getName()).append("`");
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" WHERE ");
            sb.append(condition);
        }
        List<String> allPartitionNames = this.getPartitionNames(datasource, tableMeta);
        try (Connection conn = datasource.getConnectionReadOnly();){
            ResultSet resultSet = conn.prepareStatement(sb.toString()).executeQuery();
            if (resultSet.next()) {
                String partitions = resultSet.getString("partitions");
                log.info("Explain partitions:{}", (Object)partitions);
                if (StringUtils.isNotEmpty((String)partitions)) {
                    affectedPartitions = Arrays.asList(partitions.split(","));
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse the execution plan, defaulting to processing all partitions.", (Throwable)e);
            affectedPartitions = Collections.emptyList();
        }
        affectedPartitions = affectedPartitions.isEmpty() ? allPartitionNames : affectedPartitions.stream().filter(allPartitionNames::contains).collect(Collectors.toList());
        return affectedPartitions;
    }

    @Override
    public List<String> getPartitionNames(DataSourceAdapter datasource, TableMeta tableMeta) throws SQLException {
        LinkedList<String> res = new LinkedList<String>();
        try (Connection conn = datasource.getConnectionReadOnly();){
            PreparedStatement preparedStatement = conn.prepareStatement("select partition_name from `information_schema`.`PARTITIONS` where table_schema = ? and table_name = ? order by PARTITION_ORDINAL_POSITION");
            preparedStatement.setString(1, datasource.getSchema());
            preparedStatement.setString(2, tableMeta.getName());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String pName = resultSet.getString(1);
                if (!StringUtils.isNotEmpty((String)pName)) continue;
                res.add(pName);
            }
        }
        if (res.isEmpty()) {
            res.add("");
        }
        return res;
    }
}

