/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.partition;

import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.partition.IPartitionService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;

public class OBOraclePartitionService
implements IPartitionService {
    private static final String GET_PARTITION_NAME_SQL = "SELECT PARTITION_NAME FROM ALL_TAB_PARTITIONS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY PARTITION_POSITION";

    @Override
    public List<String> getAffectedPartitions(DataSourceAdapter datasource, TableMeta tableMeta, String condition) throws SQLException {
        return this.getPartitionNames(datasource, tableMeta);
    }

    @Override
    public List<String> getPartitionNames(DataSourceAdapter datasource, TableMeta tableMeta) throws SQLException {
        try (Connection connection = datasource.getConnectionReadOnly();){
            QueryRunner queryRunner = new QueryRunner();
            Object[] params = new String[]{datasource.getSchema().toUpperCase(), tableMeta.getName().toUpperCase()};
            List result = (List)queryRunner.query(connection, GET_PARTITION_NAME_SQL, (ResultSetHandler)new MapListHandler(), params);
            List<String> partitionNames = result.stream().map(o -> (String)o.get("PARTITION_NAME")).collect(Collectors.toList());
            if (partitionNames.isEmpty()) {
                partitionNames.add("");
            }
            List<String> list = partitionNames;
            return list;
        }
    }
}

