/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.partition;

import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.partition.IPartitionService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresPartitionService
implements IPartitionService {
    private static final Logger log = LoggerFactory.getLogger(PostgresPartitionService.class);
    private static final Pattern seqScanPattern = Pattern.compile("Seq Scan on (\\w+)");
    private static final Pattern indexSeqScanPattern = Pattern.compile("Index Scan using (\\w+)_pkey on (\\w+)");
    private static final String GET_PARTITION_NAME_SQL = "select inhrelid::regclass AS partition_name from pg_class c join pg_inherits i on i.inhrelid = c. oid join pg_class d on d.oid = i.inhparent where d.relname = '%s'";

    @Override
    public List<String> getAffectedPartitions(DataSourceAdapter datasource, TableMeta tableMeta, String condition) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("EXPLAIN ANALYZE SELECT * FROM ");
        sb.append(tableMeta.getName());
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" WHERE ");
            sb.append(condition);
        }
        ArrayList<String> affectedPartitions = new ArrayList<String>();
        try (Connection conn = datasource.getConnectionReadOnly();){
            ResultSet resultSet = conn.prepareStatement(sb.toString()).executeQuery();
            while (resultSet.next()) {
                Matcher matcher = seqScanPattern.matcher(resultSet.getString(1));
                Matcher matcher0 = indexSeqScanPattern.matcher(resultSet.getString(1));
                while (matcher.find()) {
                    affectedPartitions.add(matcher.group(1));
                }
                while (matcher0.find()) {
                    affectedPartitions.add(matcher0.group(1));
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse the execution plan, defaulting to processing all partitions.", (Throwable)e);
        }
        if (affectedPartitions.isEmpty()) {
            return this.getPartitionNames(datasource, tableMeta);
        }
        return affectedPartitions;
    }

    @Override
    public List<String> getPartitionNames(DataSourceAdapter datasource, TableMeta tableMeta) throws SQLException {
        LinkedList<String> res = new LinkedList<String>();
        try (Connection conn = datasource.getConnectionReadOnly();){
            PreparedStatement preparedStatement = conn.prepareStatement(String.format(GET_PARTITION_NAME_SQL, tableMeta.getName()));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String pName = resultSet.getString(1);
                if (!StringUtils.isNotEmpty((String)pName)) continue;
                res.add(pName);
            }
        }
        if (res.isEmpty()) {
            res.add("");
        }
        return res;
    }
}

