/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.table;

import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.table.TableAccessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableAccessor
implements TableAccessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableAccessor.class);

    @Override
    public List<ColumnMeta> getTableColumns(Connection conn, String schemaName, String tableName) throws SQLException {
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<String>> getTableIndex2Columns(Connection conn, String schemaName, String tableName) throws SQLException {
        TreeMap<String, List<String>> indexName2Columns = new TreeMap<String, List<String>>();
        try (PreparedStatement ps = conn.prepareStatement(this.getTableIndex2ColumnsSql());){
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                String ukColumnName = resultSet.getString("UK_INDEX_COLUMNS");
                indexName2Columns.put(indexName, Arrays.asList(StringUtils.split((String)ukColumnName, (String)",")));
            }
        }
        return indexName2Columns;
    }

    protected abstract String getTableIndex2ColumnsSql();
}

