/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.table;

import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import com.oceanbase.tools.migrator.table.AbstractTableAccessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTableAccessor
extends AbstractTableAccessor {
    private static final Logger log = LoggerFactory.getLogger(MySQLTableAccessor.class);
    private static final String getTableIndex2ColumnsSql = "SELECT INDEX_NAME,GROUP_CONCAT(COLUMN_NAME ORDER BY SEQ_IN_INDEX SEPARATOR ',') AS UK_INDEX_COLUMNS FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND NON_UNIQUE = 0 AND NULLABLE != 'YES' GROUP BY INDEX_NAME";
    private static Pattern EXTRACT_NUMBER = Pattern.compile("(?<=\\()[^)]+");
    private static Pattern EXTRACT_VARCHAR = Pattern.compile("varchar\\((?<length>\\w+)\\)");

    @Override
    public List<ColumnMeta> getTableColumns(Connection conn, String schemaName, String tableName) throws SQLException {
        StringBuilder sb = new StringBuilder("DESC ");
        sb.append(SqlUtils.quoteMySQLIdentifier(schemaName));
        sb.append(".");
        sb.append(SqlUtils.quoteMySQLIdentifier(tableName));
        try (PreparedStatement ps = conn.prepareStatement(sb.toString());){
            ResultSet resultSet = ps.executeQuery();
            List<ColumnMeta> list = this.extractColumnMetas(resultSet);
            return list;
        }
    }

    @Override
    protected String getTableIndex2ColumnsSql() {
        return getTableIndex2ColumnsSql;
    }

    private List<ColumnMeta> extractColumnMetas(ResultSet rs) throws SQLException {
        String extraColumn = "Extra";
        String defaultColumn = "Default";
        String nullableColumn = "Null";
        String fieldColumn = "Field";
        String typeColumn = "Type";
        Pattern VIRTUAL_GENERATED = Pattern.compile("VIRTUAL GENERATED");
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
        while (rs.next()) {
            Matcher varcharMatcher;
            Matcher matcher;
            DataType dataType;
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setColIdx(columnMetas.size());
            columnMeta.setName(rs.getString(fieldColumn));
            columnMeta.setColumnType(rs.getString(typeColumn));
            columnMeta.setNullAble("YES".equals(rs.getString(nullableColumn).toUpperCase()));
            columnMeta.setExtra(rs.getString(extraColumn));
            columnMeta.setDefaultValue("NULL".equals(rs.getString(defaultColumn)) ? null : rs.getString(defaultColumn));
            Pattern virtualGenPattern = VIRTUAL_GENERATED;
            Matcher virtualGenMatcher = virtualGenPattern.matcher(columnMeta.getExtra());
            if (virtualGenMatcher.find()) continue;
            String typeLower = columnMeta.getColumnType().toLowerCase();
            if (typeLower.contains("enum") || typeLower.contains("set")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("geometry") || typeLower.contains("point")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("polygon") || typeLower.contains("linestring")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("geomcollection")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("int")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("char")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("varchar")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("text")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("numeric")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("decimal")) {
                dataType = DataType.DECIMAL;
            } else if (typeLower.contains("datetime")) {
                dataType = DataType.DATETIME;
            } else if (typeLower.contains("date") || typeLower.contains("year")) {
                dataType = DataType.DATE;
            } else if (typeLower.contains("timestamp")) {
                dataType = DataType.MYSQL_TIMESTAMP;
            } else if (typeLower.contains("time")) {
                dataType = DataType.TIME;
            } else if (typeLower.contains("binary") || typeLower.contains("blob")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("double")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("float")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("json")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("bit")) {
                dataType = DataType.BYTES;
            } else {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type: " + typeLower);
            }
            columnMeta.setType(dataType);
            if ((dataType == DataType.NUMBER || dataType == DataType.DECIMAL || dataType == DataType.DOUBLE) && (matcher = EXTRACT_NUMBER.matcher(columnMeta.getColumnType())).find()) {
                if (matcher.group().contains(",")) {
                    String[] nums = matcher.group().split(",");
                    columnMeta.setPrecision(Integer.valueOf(nums[0]));
                    columnMeta.setScope(Integer.valueOf(nums[1]));
                } else {
                    columnMeta.setPrecision(Integer.valueOf(matcher.group()));
                    columnMeta.setScope(0);
                }
            }
            if (dataType == DataType.STRING && (varcharMatcher = EXTRACT_VARCHAR.matcher(columnMeta.getColumnType())).matches()) {
                int dataLength = Integer.valueOf(varcharMatcher.group("length"));
                columnMeta.setDataLength(dataLength);
            }
            columnMetas.add(columnMeta);
        }
        return columnMetas;
    }
}

