/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.table;

import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import com.oceanbase.tools.migrator.table.AbstractTableAccessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTableAccessor
extends AbstractTableAccessor {
    private static final Logger log = LoggerFactory.getLogger(OracleTableAccessor.class);
    private static final String getTableIndex2ColumnsSql = "SELECT cons.constraint_name AS INDEX_NAME,listagg(cols.column_name, ',') WITHIN GROUP (ORDER BY cols.position) AS UK_INDEX_COLUMNS FROM all_cons_columns cols JOIN all_constraints cons ON cons.constraint_name = cols.constraint_name AND cons.owner = cols.owner WHERE cons.constraint_type = 'P' AND cons.owner = ? AND cols.table_name = ? GROUP BY cons.constraint_name";
    private static final String getTableColumnsSql = "SELECT COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_SCALE,NULLABLE,DATA_DEFAULT FROM ALL_TAB_COLUMNS WHERE OWNER = ? AND TABLE_NAME = ? ORDER BY COLUMN_ID";

    @Override
    public List<ColumnMeta> getTableColumns(Connection conn, String schemaName, String tableName) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(SqlUtils.quoteOracleIdentifier(schemaName));
        sb.append(".");
        sb.append(SqlUtils.quoteOracleIdentifier(tableName));
        try (PreparedStatement ps = conn.prepareStatement(getTableColumnsSql);){
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            ResultSet resultSet = ps.executeQuery();
            List<ColumnMeta> list = this.extractColumnMetas(resultSet);
            return list;
        }
    }

    @Override
    protected String getTableIndex2ColumnsSql() {
        return getTableIndex2ColumnsSql;
    }

    private List<ColumnMeta> extractColumnMetas(ResultSet rs) throws SQLException {
        String oracleFieldColumn = "COLUMN_NAME";
        String oracleTypeColumn = "DATA_TYPE";
        String oracleDataLengthColumn = "DATA_LENGTH";
        String oracleDataScaleColumn = "DATA_SCALE";
        String oracleNullAbleColumn = "NULLABLE";
        String oracleDefaultColumn = "DATA_DEFAULT";
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
        while (rs.next()) {
            DataType dataType;
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setColIdx(columnMetas.size());
            columnMeta.setName(rs.getString(oracleFieldColumn));
            columnMeta.setColumnType(rs.getString(oracleTypeColumn));
            columnMeta.setDataLength(rs.getInt(oracleDataLengthColumn));
            columnMeta.setNullAble("Y".equals(rs.getString(oracleNullAbleColumn)));
            columnMeta.setDefaultValue(rs.getString(oracleDefaultColumn));
            String typeLower = columnMeta.getColumnType().toLowerCase();
            if (typeLower.contains("interval year to month")) {
                dataType = DataType.INTERVAL_YM;
            } else if (typeLower.contains("interval day to second")) {
                dataType = DataType.INTERVAL_DS;
            } else if (typeLower.contains("internal")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("int")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("char")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("decimal")) {
                dataType = DataType.DECIMAL;
            } else if (typeLower.contains("number")) {
                dataType = rs.getInt(oracleDataScaleColumn) > 0 ? DataType.DECIMAL : DataType.NUMBER;
            } else if (typeLower.contains("date")) {
                dataType = DataType.DATE;
            } else if (typeLower.contains("timestamp")) {
                dataType = DataType.TIMESTAMP;
            } else if (typeLower.contains("double") || typeLower.contains("float")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("clob")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("rowid")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("raw")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("blob")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("json")) {
                dataType = DataType.STRING;
            } else {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type: " + typeLower);
            }
            if (dataType == DataType.DECIMAL) {
                columnMeta.setPrecision(rs.getInt(oracleDataLengthColumn));
                columnMeta.setScope(rs.getInt(oracleDataScaleColumn));
            }
            columnMeta.setType(dataType);
            columnMetas.add(columnMeta);
        }
        return columnMetas;
    }
}

