/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.table;

import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.table.AbstractTableAccessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostgresTableAccessor
extends AbstractTableAccessor {
    private static final String getTableIndex2ColumnsSql = "SELECT case   when kc.constraint_name like '%pkey%' THEN 'PRIMARY' when kc.constraint_name like '%uk%' THEN 'UK' else kc.constraint_name end as INDEX_NAME,    string_agg(kc.column_name , ',' ORDER BY kc.ordinal_position) AS UK_INDEX_COLUMNS FROM information_schema.table_constraints AS tc  JOIN information_schema.key_column_usage AS kc  ON tc.constraint_name = kc.constraint_name AND tc.table_schema = kc.table_schema  AND tc.table_name = kc.table_name  WHERE tc.table_schema = ? and tc.table_name = ? GROUP BY INDEX_NAME;";

    @Override
    public List<ColumnMeta> getTableColumns(Connection conn, String schemaName, String tableName) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append("column_name, data_type, is_nullable, column_default, numeric_precision, numeric_scale,");
        sb.append("character_maximum_length as data_length, udt_name,table_name ");
        sb.append("from information_schema.columns ");
        sb.append("where table_schema = ? ");
        sb.append(" and ");
        sb.append("table_name = ? ");
        sb.append(" order by ordinal_position;");
        try (PreparedStatement ps = conn.prepareStatement(sb.toString());){
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            ResultSet resultSet = ps.executeQuery();
            List<ColumnMeta> list = this.extractColumnMetas(resultSet);
            return list;
        }
    }

    @Override
    protected String getTableIndex2ColumnsSql() {
        return getTableIndex2ColumnsSql;
    }

    public List<ColumnMeta> extractColumnMetas(ResultSet rs) throws SQLException {
        String fieldColumn = "column_name";
        String columnType = "data_type";
        String nullableColumn = "is_nullable";
        String defaultColumn = "column_default";
        String precision = "numeric_precision";
        String scale = "numeric_scale";
        String dataLength = "data_length";
        String arraysFlag = "udt_name";
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
        while (rs.next()) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setColIdx(columnMetas.size());
            columnMeta.setName(rs.getString(fieldColumn));
            columnMeta.setColumnType(rs.getString(columnType));
            columnMeta.setNullAble("YES".equals(rs.getString(nullableColumn)));
            columnMeta.setDefaultValue(rs.getString(defaultColumn));
            columnMeta.setDataLength(rs.getInt(dataLength));
            String typeLower = columnMeta.getColumnType().toLowerCase();
            DataType dataType = rs.getString(arraysFlag).startsWith("_") ? DataType.OTHERS : (typeLower.contains("interval") || typeLower.contains("point") ? DataType.OTHERS : (typeLower.contains("bigint") || typeLower.contains("bigserial") ? DataType.LONG : (typeLower.contains("int") || typeLower.contains("serial") ? DataType.NUMBER : (typeLower.contains("decimal") || typeLower.contains("numeric") ? DataType.NUMBER : (typeLower.contains("real") || typeLower.contains("double") ? DataType.DOUBLE : (typeLower.contains("char") || typeLower.contains("text") ? DataType.STRING : (typeLower.contains("byte") || typeLower.contains("varying") ? DataType.BYTES : (typeLower.contains("bit") ? DataType.BIT : (typeLower.contains("timestamptz") ? DataType.TIMESTAMP_WITH_TIME_ZONE : (typeLower.contains("timestamp") ? DataType.TIMESTAMP : (typeLower.contains("timetz") ? DataType.TIME_WITH_TIME_ZONE : (typeLower.contains("time") ? DataType.TIME : (typeLower.contains("date") ? DataType.DATE : (typeLower.contains("bool") ? DataType.BOOL : (typeLower.contains("json") ? DataType.STRING : (typeLower.contains("xml") ? DataType.BYTES : DataType.OTHERS))))))))))))))));
            columnMeta.setType(dataType);
            if (dataType == DataType.NUMBER || dataType == DataType.DOUBLE) {
                columnMeta.setPrecision(rs.getInt(precision));
                columnMeta.setScope(rs.getInt(scale));
            }
            columnMetas.add(columnMeta);
        }
        return columnMetas;
    }
}

