/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.table;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.table.MySQLTableAccessor;
import com.oceanbase.tools.migrator.table.OBMySQLTableAccessor;
import com.oceanbase.tools.migrator.table.OBOracleTableAccessor;
import com.oceanbase.tools.migrator.table.OracleTableAccessor;
import com.oceanbase.tools.migrator.table.PostgresTableAccessor;
import com.oceanbase.tools.migrator.table.TableAccessor;

public class TableAccessorFactory {
    public static TableAccessor get(DataBaseType dbType) {
        switch (dbType) {
            case OB_ORACLE: {
                return new OBOracleTableAccessor();
            }
            case ORACLE: {
                return new OracleTableAccessor();
            }
            case OB_MYSQL: {
                return new OBMySQLTableAccessor();
            }
            case MYSQL: {
                return new MySQLTableAccessor();
            }
            case POSTGRESQL: {
                return new PostgresTableAccessor();
            }
        }
        throw new IllegalArgumentException();
    }
}

