/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBForeignKeyModifyRule;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DBTableConstraintEditor
implements DBObjectEditor<DBTableConstraint> {
    @Override
    public boolean editable() {
        return true;
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBTableConstraint constraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(constraint)).append(" ADD CONSTRAINT ").identifierIf(constraint.getName(), StringUtils.isNotEmpty((CharSequence)constraint.getName())).space();
        this.appendConstraintType(constraint, sqlBuilder);
        this.appendConstraintColumns(constraint, sqlBuilder);
        this.appendConstraintOptions(constraint, sqlBuilder);
        return sqlBuilder.toString().trim();
    }

    protected void appendConstraintOptions(DBTableConstraint constraint, SqlBuilder sqlBuilder) {
        if (Objects.nonNull((Object)constraint.getMatchType())) {
            sqlBuilder.append(" MATCH ").append(constraint.getMatchType().name());
        }
        if (Objects.nonNull((Object)constraint.getOnDeleteRule()) && constraint.getOnDeleteRule() != DBForeignKeyModifyRule.NO_ACTION) {
            sqlBuilder.append(" ON DELETE ").append(constraint.getOnDeleteRule().getValue());
        }
    }

    protected void appendConstraintColumns(DBTableConstraint constraint, SqlBuilder sqlBuilder) {
        if (constraint.getType() == DBConstraintType.CHECK) {
            sqlBuilder.append("(").append(constraint.getCheckClause()).append(")").space();
            return;
        }
        List<String> columnNames = constraint.getColumnNames();
        if (Objects.isNull(columnNames)) {
            return;
        }
        sqlBuilder.append("(");
        boolean isFirstColumn = true;
        for (String columnName : columnNames) {
            if (!isFirstColumn) {
                sqlBuilder.append(", ");
            }
            isFirstColumn = false;
            sqlBuilder.identifier(columnName);
        }
        sqlBuilder.append(")");
        if (constraint.getType() == DBConstraintType.FOREIGN_KEY) {
            sqlBuilder.append(" REFERENCES ").identifier(constraint.getReferenceSchemaName()).append(".").identifier(constraint.getReferenceTableName()).append(" (");
            isFirstColumn = true;
            for (String refColumnName : constraint.getReferenceColumnNames()) {
                if (!isFirstColumn) {
                    sqlBuilder.append(", ");
                }
                isFirstColumn = false;
                sqlBuilder.identifier(refColumnName);
            }
            sqlBuilder.append(")");
        }
    }

    protected void appendConstraintType(DBTableConstraint constraint, SqlBuilder sqlBuilder) {
        sqlBuilder.append(constraint.getType().getValue()).space();
    }

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBTableConstraint constraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (Objects.isNull(constraint.getName())) {
            constraint.setName("");
        }
        sqlBuilder.append("CONSTRAINT ").identifierIf(constraint.getName(), StringUtils.isNotEmpty((CharSequence)constraint.getName())).space();
        this.appendConstraintType(constraint, sqlBuilder);
        this.appendConstraintColumns(constraint, sqlBuilder);
        this.appendConstraintOptions(constraint, sqlBuilder);
        return sqlBuilder.toString().trim();
    }

    @Override
    public String generateUpdateObjectDDL(@NotNull DBTableConstraint oldConstraint, @NotNull DBTableConstraint newConstraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (!Objects.equals(oldConstraint, newConstraint)) {
            String drop = this.generateDropObjectDDL(oldConstraint);
            sqlBuilder.append(drop).append(";").line().append(this.generateCreateObjectDDL(newConstraint)).append(";").line();
            return sqlBuilder.toString();
        }
        if (!Objects.equals(oldConstraint.getEnabled(), newConstraint.getEnabled())) {
            sqlBuilder.append(this.generateEnableOrDisableConstraintDDL(newConstraint));
        }
        if (!StringUtils.equals((CharSequence)oldConstraint.getName(), (CharSequence)newConstraint.getName())) {
            sqlBuilder.append(this.generateRenameObjectDDL(oldConstraint, newConstraint));
        }
        return sqlBuilder.toString();
    }

    protected String generateEnableOrDisableConstraintDDL(@NotNull DBTableConstraint newConstraint) {
        return "";
    }

    @Override
    public String generateUpdateObjectListDDL(Collection<DBTableConstraint> oldConstraints, Collection<DBTableConstraint> newConstraints) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (CollectionUtils.isEmpty(oldConstraints)) {
            if (CollectionUtils.isNotEmpty(newConstraints)) {
                newConstraints.forEach(constraint -> sqlBuilder.append(this.generateCreateObjectDDL((DBTableConstraint)constraint)).append(";\n"));
            }
            return sqlBuilder.toString();
        }
        if (CollectionUtils.isEmpty(newConstraints)) {
            if (CollectionUtils.isNotEmpty(oldConstraints)) {
                oldConstraints.forEach(constraint -> sqlBuilder.append(this.generateDropObjectDDL(constraint)).append(";\n"));
            }
            return sqlBuilder.toString();
        }
        HashMap position2OldConstraint = new HashMap();
        HashMap position2NewConstraint = new HashMap();
        oldConstraints.forEach(oldConstraint -> position2OldConstraint.put(oldConstraint.getOrdinalPosition(), oldConstraint));
        newConstraints.forEach(newConstraint -> {
            if (Objects.nonNull(newConstraint.getOrdinalPosition())) {
                position2NewConstraint.put(newConstraint.getOrdinalPosition(), newConstraint);
            }
        });
        for (DBTableConstraint newConstraint2 : newConstraints) {
            if (Objects.isNull(newConstraint2.getOrdinalPosition())) {
                sqlBuilder.append(this.generateCreateObjectDDL(newConstraint2)).append(";\n");
                continue;
            }
            if (!position2OldConstraint.containsKey(newConstraint2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateUpdateObjectDDL((DBTableConstraint)position2OldConstraint.get(newConstraint2.getOrdinalPosition()), newConstraint2));
        }
        for (DBTableConstraint oldConstraint2 : oldConstraints) {
            if (position2NewConstraint.containsKey(oldConstraint2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateDropObjectDDL(oldConstraint2)).append(";").line();
        }
        return sqlBuilder.toString();
    }

    protected abstract SqlBuilder sqlBuilder();

    protected String getFullyQualifiedTableName(@NotNull DBTableConstraint constraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (StringUtils.isNotEmpty((CharSequence)constraint.getSchemaName())) {
            sqlBuilder.identifier(constraint.getSchemaName()).append(".");
        }
        if (StringUtils.isNotEmpty((CharSequence)constraint.getTableName())) {
            sqlBuilder.identifier(constraint.getTableName());
        }
        return sqlBuilder.toString();
    }
}

