/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTableEditor;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.NonNull;

public class MySQLTableEditor
extends DBTableEditor {
    public MySQLTableEditor(DBObjectEditor<DBTableIndex> indexEditor, DBObjectEditor<DBTableColumn> columnEditor, DBObjectEditor<DBTableConstraint> constraintEditor, DBObjectEditor<DBTablePartition> partitionEditor) {
        super(indexEditor, columnEditor, constraintEditor, partitionEditor);
    }

    @Override
    protected void appendColumnComment(DBTable table, SqlBuilder sqlBuilder) {
    }

    @Override
    protected void appendTableComment(DBTable table, SqlBuilder sqlBuilder) {
    }

    @Override
    protected boolean createIndexWhenCreatingTable() {
        return true;
    }

    @Override
    protected void appendTableOptions(DBTable table, SqlBuilder sqlBuilder) {
        if (Objects.isNull(table.getTableOptions())) {
            return;
        }
        DBTable.DBTableOptions options = table.getTableOptions();
        if (Objects.nonNull(options.getAutoIncrementInitialValue())) {
            sqlBuilder.append("AUTO_INCREMENT = ").append(String.valueOf(options.getAutoIncrementInitialValue())).space();
        }
        if (StringUtils.isNotBlank((CharSequence)options.getCharsetName())) {
            sqlBuilder.append("DEFAULT CHARSET = ").append(options.getCharsetName()).space();
        }
        if (StringUtils.isNotBlank((CharSequence)options.getCollationName())) {
            sqlBuilder.append("COLLATE = ").append(options.getCollationName()).space();
        }
        if (StringUtils.isNotBlank((CharSequence)options.getCompressionOption())) {
            sqlBuilder.append("COMPRESSION = ").append(options.getCompressionOption()).space();
        }
        super.appendTableOptions(table, sqlBuilder);
        if (StringUtils.isNotEmpty((CharSequence)options.getComment())) {
            sqlBuilder.append("COMMENT = ").value(options.getComment()).space();
        }
    }

    @Override
    protected void generateUpdateTableOptionDDL(@NonNull DBTable oldTable, @NonNull DBTable newTable, @NonNull SqlBuilder sqlBuilder) {
        if (oldTable == null) {
            throw new NullPointerException("oldTable is marked non-null but is null");
        }
        if (newTable == null) {
            throw new NullPointerException("newTable is marked non-null but is null");
        }
        if (sqlBuilder == null) {
            throw new NullPointerException("sqlBuilder is marked non-null but is null");
        }
        if (Objects.isNull(oldTable.getTableOptions()) || Objects.isNull(newTable.getTableOptions())) {
            return;
        }
        if (!StringUtils.equals((CharSequence)oldTable.getTableOptions().getComment(), (CharSequence)newTable.getTableOptions().getComment())) {
            sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(newTable)).append(" COMMENT = ").value(newTable.getTableOptions().getComment()).append(";\n");
        }
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTable oldTable, @NotNull DBTable newTable) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").identifier(oldTable.getName()).append(" RENAME TO ").identifier(newTable.getName());
        return sqlBuilder.toString();
    }
}

