/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.util.CollectionUtils;

public class OracleDBTablePartitionEditor
extends DBTablePartitionEditor {
    @Override
    protected void appendDefinitions(DBTablePartition partition, SqlBuilder sqlBuilder) {
        DBTablePartitionType type = partition.getPartitionOption().getType();
        if (type == DBTablePartitionType.HASH && CollectionUtils.isEmpty(partition.getPartitionDefinitions())) {
            return;
        }
        sqlBuilder.append("(\n");
        boolean isFirstColumn = true;
        for (DBTablePartitionDefinition definition : partition.getPartitionDefinitions()) {
            if (!isFirstColumn) {
                sqlBuilder.append(",").line();
            }
            this.appendDefinition(partition.getPartitionOption(), definition, sqlBuilder);
            isFirstColumn = false;
        }
        sqlBuilder.append("\n)");
    }

    @Override
    protected void appendDefinition(DBTablePartitionOption option, DBTablePartitionDefinition definition, SqlBuilder sqlBuilder) {
        sqlBuilder.append("PARTITION ").identifier(definition.getName());
        if (option.getType() == DBTablePartitionType.RANGE && Objects.nonNull(definition.getMaxValues())) {
            sqlBuilder.append(" VALUES LESS THAN (").append(String.join((CharSequence)",", definition.getMaxValues())).append(")");
        } else if (option.getType() == DBTablePartitionType.LIST && Objects.nonNull(definition.getValuesList())) {
            sqlBuilder.append(" VALUES (").append(DBSchemaAccessorUtil.parseListRangeValuesList(definition.getValuesList())).append(")");
        }
    }

    @Override
    protected String generateAddPartitionDefinitionDDL(@NotNull DBTablePartitionDefinition definition, @NotNull DBTablePartitionOption option, String fullyQualifiedTableName) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(fullyQualifiedTableName).append(" ADD ");
        this.appendDefinition(option, definition, sqlBuilder);
        sqlBuilder.append(";").line();
        return sqlBuilder.toString();
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }
}

