/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import com.oceanbase.tools.dbbrowser.parser.TimeoutTokenStream;
import com.oceanbase.tools.dbbrowser.parser.listener.CustomErrorListener;
import com.oceanbase.tools.dbbrowser.parser.listener.MysqlModeSqlParserListener;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModeSqlParserListener;
import com.oceanbase.tools.dbbrowser.parser.result.ParseSqlResult;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBLexer;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParser {
    private static final Logger log = LoggerFactory.getLogger(SqlParser.class);

    public static ParseSqlResult parseMysql(String sql) {
        return SqlParser.parseMysql(sql, 0L);
    }

    public static ParseSqlResult parseMysql(String sql, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        CodePointCharStream input = CharStreams.fromString((String)sql);
        com.oceanbase.tools.sqlparser.obmysql.OBLexer lexer = new com.oceanbase.tools.sqlparser.obmysql.OBLexer((CharStream)input);
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        com.oceanbase.tools.sqlparser.obmysql.OBParser parser = new com.oceanbase.tools.sqlparser.obmysql.OBParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new CustomErrorListener());
        OBParser.StmtContext tree = parser.stmt();
        MysqlModeSqlParserListener listener = new MysqlModeSqlParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        log.info("Time cost for sql parsing is {}ms, sql={}", (Object)(System.currentTimeMillis() - startTime), (Object)sql);
        return new ParseSqlResult(listener);
    }

    public static ParseSqlResult parseOracle(String sql) {
        return SqlParser.parseOracle(sql, 0L);
    }

    public static ParseSqlResult parseOracle(String sql, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        CodePointCharStream input = CharStreams.fromString((String)sql);
        OBLexer lexer = new OBLexer((CharStream)input);
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        OBParser parser = new OBParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new CustomErrorListener());
        OBParser.StmtContext tree = parser.stmt();
        OracleModeSqlParserListener listener = new OracleModeSqlParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        log.info("Time cost for sql parsing is {}ms, sql={}", (Object)(System.currentTimeMillis() - startTime), (Object)sql);
        return new ParseSqlResult(listener);
    }
}

