/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class TimeoutTokenStream
extends CommonTokenStream {
    private final long timeoutTimestamp;

    public TimeoutTokenStream(TokenSource tokenSource, long timeoutMillis) {
        super(tokenSource);
        this.timeoutTimestamp = timeoutMillis <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeoutMillis;
    }

    public int LA(int i) {
        this.checkTimeout();
        return super.LA(i);
    }

    public Token LT(int k) {
        this.checkTimeout();
        return super.LT(k);
    }

    private void checkTimeout() {
        if (System.currentTimeMillis() <= this.timeoutTimestamp) {
            return;
        }
        throw new ParseCancellationException("Timeout for parser, abort!");
    }
}

