/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.schema.mysql.MySQLNoGreaterThan5740SchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.jdbc.core.JdbcOperations;

public class ODPOBMySQLSchemaAccessor
extends MySQLNoGreaterThan5740SchemaAccessor {
    public ODPOBMySQLSchemaAccessor(JdbcOperations jdbcOperations) {
        super(jdbcOperations);
    }

    @Override
    public List<String> showTables(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW TABLES ");
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            sb.append("FROM ");
            sb.identifier(schemaName);
            sb.append(" ");
        }
        String sql = sb.toString();
        return this.jdbcOperations.queryForList(sql, String.class);
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        String sql = "select database()";
        String currentSchema = (String)this.jdbcOperations.queryForObject(sql, (rs, rowNum) -> rs.getString(1));
        ArrayList<DBObjectIdentity> results = new ArrayList<DBObjectIdentity>();
        sql = "show full tables where Table_type='BASE TABLE'";
        List views = this.jdbcOperations.query(sql, (rs, rowNum) -> rs.getString(1));
        views.forEach(name -> results.add(DBObjectIdentity.of(currentSchema, DBObjectType.VIEW, name)));
        return results;
    }

    @Override
    public List<String> showTablesLike(String schemaName, String tableNameLike) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        if (tableNameLike == null) {
            sb.append("show tables");
        } else {
            sb.append("show tables like ").value("%" + tableNameLike + "%");
        }
        return this.jdbcOperations.queryForList(sb.toString(), String.class);
    }

    @Override
    public List<DBObjectIdentity> listViews(String schemaName) {
        return Collections.emptyList();
    }

    @Override
    public List<DBObjectIdentity> listAllViews(String viewNameLike) {
        return Collections.emptyList();
    }

    @Override
    public List<DBObjectIdentity> listAllUserViews() {
        String sql = "select database()";
        String currentSchema = (String)this.jdbcOperations.queryForObject(sql, (rs, rowNum) -> rs.getString(1));
        ArrayList<DBObjectIdentity> results = new ArrayList<DBObjectIdentity>();
        sql = "show full tables where Table_type='VIEW'";
        List views = this.jdbcOperations.query(sql, (rs, rowNum) -> rs.getString(1));
        views.forEach(name -> results.add(DBObjectIdentity.of(currentSchema, DBObjectType.VIEW, name)));
        return results;
    }

    @Override
    public List<DBObjectIdentity> listAllSystemViews() {
        return Collections.emptyList();
    }

    @Override
    public List<DBPLObjectIdentity> listFunctions(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listProcedures(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBFunction getFunction(String schemaName, String functionName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBProcedure getProcedure(String schemaName, String procedureName) {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

