/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBObject;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class DBObjectEditorUtils {
    public static void generateShadowTableColumnListUpdateDDL(List<DBTableColumn> oldColumns, List<DBTableColumn> newColumns, DBObjectEditor<DBTableColumn> editor, SqlBuilder sqlBuilder) {
        if (CollectionUtils.isEmpty(oldColumns)) {
            if (CollectionUtils.isNotEmpty(newColumns)) {
                newColumns.forEach(column -> sqlBuilder.append(editor.generateCreateObjectDDL((DBTableColumn)column)));
            }
            return;
        }
        if (CollectionUtils.isEmpty(newColumns)) {
            if (CollectionUtils.isNotEmpty(oldColumns)) {
                oldColumns.forEach(column -> sqlBuilder.append(editor.generateDropObjectDDL((DBTableColumn)column)));
            }
            return;
        }
        HashMap name2OldColumn = new HashMap();
        HashMap name2NewColumn = new HashMap();
        oldColumns.forEach(oldColumn -> name2OldColumn.put(oldColumn.getName(), oldColumn));
        newColumns.forEach(newColumn -> {
            if (Objects.nonNull(newColumn.getName())) {
                name2NewColumn.put(newColumn.getName(), newColumn);
            }
        });
        for (DBTableColumn newColumn2 : newColumns) {
            if (!name2OldColumn.containsKey(newColumn2.getName())) {
                sqlBuilder.append(editor.generateCreateObjectDDL(newColumn2));
                continue;
            }
            sqlBuilder.append(editor.generateUpdateObjectDDL((DBTableColumn)((DBObject)name2OldColumn.get(newColumn2.getName())), newColumn2));
        }
        for (DBTableColumn oldColumn2 : oldColumns) {
            if (name2NewColumn.containsKey(oldColumn2.getName())) continue;
            sqlBuilder.append(editor.generateDropObjectDDL(oldColumn2));
        }
    }

    public static void generateShadowIndexListUpdateDDL(List<DBTableIndex> oldIndexes, List<DBTableIndex> newIndexes, DBObjectEditor<DBTableIndex> editor, SqlBuilder sqlBuilder) {
        if (CollectionUtils.isEmpty(oldIndexes)) {
            if (CollectionUtils.isNotEmpty(newIndexes)) {
                newIndexes.forEach(column -> sqlBuilder.append(editor.generateCreateObjectDDL((DBTableIndex)column)).append(";\n"));
            }
            return;
        }
        if (CollectionUtils.isEmpty(newIndexes)) {
            if (CollectionUtils.isNotEmpty(oldIndexes)) {
                oldIndexes.forEach(column -> sqlBuilder.append(editor.generateDropObjectDDL((DBTableIndex)column)).append(";\n"));
            }
            return;
        }
        HashMap name2OldIndex = new HashMap();
        HashMap name2NewIndex = new HashMap();
        oldIndexes.forEach(oldIndex -> name2OldIndex.put(oldIndex.getName(), oldIndex));
        newIndexes.forEach(newIndex -> {
            if (Objects.nonNull(newIndex.getName())) {
                name2NewIndex.put(newIndex.getName(), newIndex);
            }
        });
        for (DBTableIndex newIndex2 : newIndexes) {
            if (!name2OldIndex.containsKey(newIndex2.getName())) {
                sqlBuilder.append(editor.generateCreateObjectDDL(newIndex2)).append(";\n");
                continue;
            }
            sqlBuilder.append(editor.generateUpdateObjectDDL((DBTableIndex)((DBObject)name2OldIndex.get(newIndex2.getName())), newIndex2));
        }
        for (DBTableIndex oldIndex2 : oldIndexes) {
            if (name2NewIndex.containsKey(oldIndex2.getName())) continue;
            sqlBuilder.append(editor.generateDropObjectDDL(oldIndex2)).append(";").line();
        }
    }

    public static void generateShadowTableConstraintListUpdateDDL(List<DBTableConstraint> oldConstraints, List<DBTableConstraint> newConstraints, DBObjectEditor<DBTableConstraint> editor, SqlBuilder sqlBuilder) {
        if (Objects.isNull(oldConstraints)) {
            oldConstraints = new ArrayList<DBTableConstraint>();
        }
        if (Objects.isNull(newConstraints)) {
            newConstraints = new ArrayList<DBTableConstraint>();
        }
        Map<DBConstraintType, List<DBTableConstraint>> type2OldConstraints = oldConstraints.stream().collect(Collectors.groupingBy(DBTableConstraint::getType));
        Map<DBConstraintType, List<DBTableConstraint>> type2NewConstraints = newConstraints.stream().collect(Collectors.groupingBy(DBTableConstraint::getType));
        DBObjectEditorUtils.generateForeignKeyDDL(type2OldConstraints.getOrDefault((Object)DBConstraintType.FOREIGN_KEY, new ArrayList()), type2NewConstraints.getOrDefault((Object)DBConstraintType.FOREIGN_KEY, new ArrayList()), editor, sqlBuilder);
        ArrayList oldConstraintsWithoutFK = new ArrayList();
        ArrayList newConstraintsWithoutFK = new ArrayList();
        type2OldConstraints.forEach((dbConstraintType, constraints) -> {
            if (dbConstraintType != DBConstraintType.FOREIGN_KEY) {
                oldConstraintsWithoutFK.addAll(constraints);
            }
        });
        type2NewConstraints.forEach((dbConstraintType, constraints) -> {
            if (dbConstraintType != DBConstraintType.FOREIGN_KEY) {
                newConstraintsWithoutFK.addAll(constraints);
            }
        });
        if (CollectionUtils.isEmpty(oldConstraintsWithoutFK)) {
            if (CollectionUtils.isNotEmpty(newConstraintsWithoutFK)) {
                newConstraintsWithoutFK.forEach(constraint -> sqlBuilder.append(editor.generateCreateObjectDDL((DBTableConstraint)constraint)).append(";\n"));
            }
            return;
        }
        if (CollectionUtils.isEmpty(newConstraintsWithoutFK)) {
            if (CollectionUtils.isNotEmpty(oldConstraintsWithoutFK)) {
                oldConstraintsWithoutFK.forEach(constraint -> sqlBuilder.append(editor.generateDropObjectDDL((DBTableConstraint)constraint)).append(";\n"));
            }
            return;
        }
        HashMap name2OldConstraint = new HashMap();
        HashMap name2NewConstraint = new HashMap();
        oldConstraintsWithoutFK.forEach(oldConstraint -> name2OldConstraint.put(oldConstraint.getName(), oldConstraint));
        newConstraintsWithoutFK.forEach(newConstraint -> {
            if (Objects.nonNull(newConstraint.getName())) {
                name2NewConstraint.put(newConstraint.getName(), newConstraint);
            }
        });
        for (DBTableConstraint newConstraint2 : newConstraintsWithoutFK) {
            if (!name2OldConstraint.containsKey(newConstraint2.getName())) {
                sqlBuilder.append(editor.generateCreateObjectDDL(newConstraint2)).append(";\n");
                continue;
            }
            sqlBuilder.append(editor.generateUpdateObjectDDL((DBTableConstraint)((DBObject)name2OldConstraint.get(newConstraint2.getName())), newConstraint2));
        }
        for (DBTableConstraint oldConstraint2 : oldConstraintsWithoutFK) {
            if (name2NewConstraint.containsKey(oldConstraint2.getName())) continue;
            sqlBuilder.append(editor.generateDropObjectDDL(oldConstraint2)).append(";\n");
        }
    }

    private static void generateForeignKeyDDL(List<DBTableConstraint> oldForeignKeys, List<DBTableConstraint> newForeignKeys, DBObjectEditor<DBTableConstraint> editor, SqlBuilder sqlBuilder) {
        boolean isEqual;
        for (DBTableConstraint newConstraint : newForeignKeys) {
            isEqual = false;
            for (DBTableConstraint oldConstraint : oldForeignKeys) {
                if (!Objects.deepEquals(newConstraint, oldConstraint)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            newConstraint.setName("");
            sqlBuilder.append(editor.generateCreateObjectDDL(newConstraint)).append(";\n");
        }
        for (DBTableConstraint oldConstraint : oldForeignKeys) {
            isEqual = false;
            for (DBTableConstraint newConstraint : newForeignKeys) {
                if (!Objects.deepEquals(newConstraint, oldConstraint)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            sqlBuilder.append(editor.generateDropObjectDDL(oldConstraint)).append(";\n");
        }
    }
}

