/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBTableIndexEditor;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class OracleIndexEditor
extends DBTableIndexEditor {
    @Override
    public String generateRenameObjectDDL(@NotNull DBTableIndex oldIndex, @NotNull DBTableIndex newIndex) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER INDEX ").identifier(oldIndex.getName()).append(" RENAME TO ").identifier(newIndex.getName());
        return sqlBuilder.toString();
    }

    @Override
    protected void appendIndexColumnModifiers(DBTableIndex index, SqlBuilder sqlBuilder) {
    }

    @Override
    protected void appendIndexOptions(DBTableIndex index, SqlBuilder sqlBuilder) {
        if (Objects.nonNull(index.getGlobal())) {
            sqlBuilder.append(index.getGlobal() != false ? " GLOBAL " : " LOCAL ");
        }
        if (Objects.nonNull(index.getVisible()) && !index.getVisible().booleanValue()) {
            sqlBuilder.append(" INVISIBLE ");
        }
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBTableIndex index) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("DROP INDEX ").identifier(index.getName());
        return sqlBuilder.toString();
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }

    @Override
    public boolean editable() {
        return true;
    }
}

