/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBSynonym;
import com.oceanbase.tools.dbbrowser.model.DBSynonymType;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;

public class OracleSynonymEditor
implements DBObjectEditor<DBSynonym> {
    @Override
    public boolean editable() {
        return false;
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBSynonym dbObject) {
        Validate.notBlank((CharSequence)dbObject.getSynonymName(), (String)"Synonym name can not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbObject.getTableName(), (String)"Table name can not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dbObject.getSynonymType()), (String)"Synonym type can not be null", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE ");
        if (dbObject.getSynonymType() == DBSynonymType.PUBLIC) {
            sqlBuilder.append("PUBLIC ");
        }
        sqlBuilder.append("SYNONYM ").identifier(dbObject.getSynonymName()).append(" FOR ");
        if (StringUtils.isNotBlank((CharSequence)dbObject.getTableOwner())) {
            ((SqlBuilder)sqlBuilder).identifier(dbObject.getTableOwner()).append(".");
        }
        return ((SqlBuilder)sqlBuilder).identifier(dbObject.getTableName()).append(";").toString();
    }

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBSynonym dbObject) {
        return this.generateCreateObjectDDL(dbObject);
    }

    @Override
    public String generateUpdateObjectDDL(@NotNull DBSynonym oldObject, @NotNull DBSynonym newObject) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public String generateUpdateObjectListDDL(Collection<DBSynonym> oldObjects, Collection<DBSynonym> newObjects) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBSynonym oldObject, @NotNull DBSynonym newObject) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBSynonym dbObject) {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

