/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model;

import com.oceanbase.tools.dbbrowser.model.DBObject;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBViewCheckOption;
import com.oceanbase.tools.dbbrowser.model.DBViewColumn;
import java.util.ArrayList;
import java.util.List;

public class DBView
implements DBObject {
    private String viewName;
    private String schemaName;
    private String ddl;
    private DBViewCheckOption checkOption;
    private boolean isUpdatable;
    private String definer;
    private String comment;
    private List<DBTableColumn> columns;
    private List<DBViewUnit> viewUnits = new ArrayList<DBViewUnit>();
    private List<DBViewColumn> createColumns;
    private List<String> operations = new ArrayList<String>();

    public void setCheckOption(String checkOption) {
        this.checkOption = DBViewCheckOption.valueOf(checkOption);
    }

    public static DBView of(String schemaName, String viewName) {
        DBView dbView = new DBView();
        dbView.setSchemaName(schemaName);
        dbView.setViewName(viewName);
        return dbView;
    }

    @Override
    public String name() {
        return this.viewName;
    }

    @Override
    public DBObjectType type() {
        return DBObjectType.VIEW;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDdl(String ddl) {
        this.ddl = ddl;
    }

    public void setUpdatable(boolean isUpdatable) {
        this.isUpdatable = isUpdatable;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setColumns(List<DBTableColumn> columns) {
        this.columns = columns;
    }

    public void setViewUnits(List<DBViewUnit> viewUnits) {
        this.viewUnits = viewUnits;
    }

    public void setCreateColumns(List<DBViewColumn> createColumns) {
        this.createColumns = createColumns;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDdl() {
        return this.ddl;
    }

    public DBViewCheckOption getCheckOption() {
        return this.checkOption;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public String getDefiner() {
        return this.definer;
    }

    public String getComment() {
        return this.comment;
    }

    public List<DBTableColumn> getColumns() {
        return this.columns;
    }

    public List<DBViewUnit> getViewUnits() {
        return this.viewUnits;
    }

    public List<DBViewColumn> getCreateColumns() {
        return this.createColumns;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public static class DBViewUnit {
        private String dbName;
        private String tableName;
        private String tableAliasName;

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableAliasName() {
            return this.tableAliasName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setTableAliasName(String tableAliasName) {
            this.tableAliasName = tableAliasName;
        }
    }
}

