/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model.datatype;

import com.oceanbase.tools.dbbrowser.model.datatype.DataType;
import com.oceanbase.tools.dbbrowser.model.datatype.DataTypeFactory;
import com.oceanbase.tools.dbbrowser.model.datatype.GeneralDataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import lombok.NonNull;

public class JdbcDataTypeFactory
implements DataTypeFactory {
    private final ResultSetMetaData metaData;
    private final int columnIndex;

    public JdbcDataTypeFactory(@NonNull ResultSetMetaData metaData, int columnIndex) {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        this.metaData = metaData;
        this.columnIndex = columnIndex;
    }

    @Override
    public DataType generate() throws SQLException {
        return new GeneralDataType(this.metaData, this.columnIndex);
    }
}

