/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model.datatype.parser;

import com.oceanbase.tools.dbbrowser.model.datatype.parser.CommonDataTypeToken;
import com.oceanbase.tools.dbbrowser.model.datatype.parser.DataTypeToken;
import com.oceanbase.tools.dbbrowser.model.datatype.parser.DataTypeTokenVisitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeParser {
    private static final Logger log = LoggerFactory.getLogger(DataTypeParser.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");
    private final List<DataTypeToken> tokens;

    public DataTypeParser(@NonNull List<DataTypeToken> tokens) {
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        this.tokens = tokens;
    }

    public DataTypeParser(@NonNull String dataTypeName) {
        this(DataTypeParser.getTokens(dataTypeName));
        if (dataTypeName == null) {
            throw new NullPointerException("dataTypeName is marked non-null but is null");
        }
    }

    public static List<DataTypeToken> getTokens(String content) {
        String text;
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptyList();
        }
        int length = content.length();
        LinkedList<DataTypeToken> tokens = new LinkedList<DataTypeToken>();
        int start = 0;
        boolean matches = false;
        for (int i = 1; i <= length; ++i) {
            String text2 = content.substring(start, i);
            if (text2.trim().length() == 0) {
                start = i;
                continue;
            }
            int type = DataTypeParser.getType(text2);
            if (type == 0 && !matches) {
                tokens.add(DataTypeParser.getToken(content, start, i));
                start = i;
                continue;
            }
            if (type != 0) {
                matches = true;
                continue;
            }
            tokens.add(DataTypeParser.getToken(content, start, --i));
            start = i;
            matches = false;
        }
        if (start < length && (text = content.substring(start, length)).trim().length() != 0) {
            tokens.add(DataTypeParser.getToken(content, start, length));
        }
        return tokens;
    }

    public void parse(@NonNull DataTypeTokenVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        for (DataTypeToken token : this.tokens) {
            if (token.getType() == 0) {
                this.visit(token, visitor::visitUnknown);
                continue;
            }
            if (token.getType() == 2) {
                this.visit(token, visitor::visitBrackets);
                continue;
            }
            if (token.getType() == 1) {
                this.visit(token, visitor::visitName);
                continue;
            }
            if (token.getType() == 3) {
                this.visit(token, visitor::visitNumber);
                continue;
            }
            throw new IllegalStateException("Unknown token, " + token);
        }
    }

    private void visit(DataTypeToken token, Consumer<DataTypeToken> consumer) {
        try {
            consumer.accept(token);
        }
        catch (Exception e) {
            log.warn("Failed to visit", (Throwable)e);
        }
    }

    private static int getType(String text) {
        int type = 0;
        if (NUMBER_PATTERN.matcher(text).matches()) {
            type = 3;
        } else if (NAME_PATTERN.matcher(text).matches()) {
            type = 1;
        } else if ("(".equals(text) || ")".equals(text)) {
            type = 2;
        }
        return type;
    }

    private static DataTypeToken getToken(String content, int start, int end) {
        String text = content.substring(start, end);
        return new CommonDataTypeToken(text, start, end, DataTypeParser.getType(text));
    }
}

