/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.listener;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBPLParamMode;
import com.oceanbase.tools.dbbrowser.model.DBPLType;
import com.oceanbase.tools.dbbrowser.model.DBPLVariable;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.parser.constant.PLObjectType;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.listener.BasicParserListener;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.oracle.PlSqlParser;
import com.oceanbase.tools.sqlparser.oracle.PlSqlParserBaseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;

public class OracleModeParserListener
extends PlSqlParserBaseListener
implements BasicParserListener {
    private SqlType sqlType;
    private DBObjectType dbObjectType;
    private List<String> dbObjectNameList = new ArrayList<String>();
    private String plName;
    private String plType;
    private List<DBPLVariable> varibaleList = new ArrayList<DBPLVariable>();
    private List<DBPLType> typeList = new ArrayList<DBPLType>();
    private List<DBPLType> cursorList = new ArrayList<DBPLType>();
    private List<DBProcedure> procedureList = new ArrayList<DBProcedure>();
    private List<DBFunction> functionList = new ArrayList<DBFunction>();
    private String isOrAs;

    public void enterCreate_package(PlSqlParser.Create_packageContext ctx) {
        TerminalNode is = ctx.IS();
        this.isOrAs = is == null ? "AS" : is.getText();
        this.doRecord(SqlType.CREATE, DBObjectType.PACKAGE, ctx.package_name(0).getText());
    }

    public void enterCreate_package_body(PlSqlParser.Create_package_bodyContext ctx) {
        this.doRecord(SqlType.CREATE, DBObjectType.PACKAGE_BODY, ctx.package_name(0).getText());
    }

    public void enterAlter_package(PlSqlParser.Alter_packageContext ctx) {
        DBObjectType dbObjectType = null;
        this.dbObjectType = Objects.nonNull(ctx.BODY()) ? DBObjectType.PACKAGE_BODY : DBObjectType.PACKAGE;
        this.doRecord(SqlType.ALTER, dbObjectType, ctx.package_name().getText());
    }

    public void enterDrop_package(PlSqlParser.Drop_packageContext ctx) {
        DBObjectType dbObjectType = null;
        this.dbObjectType = Objects.nonNull(ctx.BODY()) ? DBObjectType.PACKAGE_BODY : DBObjectType.PACKAGE;
        this.doRecord(SqlType.DROP, dbObjectType, ctx.package_name().getText());
    }

    public void enterDrop_procedure(PlSqlParser.Drop_procedureContext ctx) {
        this.doRecord(SqlType.DROP, DBObjectType.PROCEDURE, ctx.procedure_name().getText());
    }

    public void enterAlter_procedure(PlSqlParser.Alter_procedureContext ctx) {
        this.doRecord(SqlType.ALTER, DBObjectType.PROCEDURE, ctx.procedure_name().getText());
    }

    public void enterCreate_procedure_body(PlSqlParser.Create_procedure_bodyContext ctx) {
        List<DBPLParam> plParamList = this.handleParameters(ctx.parameter());
        String proName = ctx.procedure_name().getText();
        String proNameWithoutQuotation = this.handleObjectName(proName);
        DBProcedure dbProcedure = new DBProcedure();
        dbProcedure.setProName(this.handleUpperCase(proName, proNameWithoutQuotation));
        dbProcedure.setParams(plParamList);
        dbProcedure.setStartline(ctx.getStart().getLine());
        dbProcedure.setStopLine(ctx.getStop().getLine());
        dbProcedure.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.procedureList.add(dbProcedure);
        this.doRecord(SqlType.CREATE, DBObjectType.PROCEDURE, proName);
    }

    public void enterProcedure_name(PlSqlParser.Procedure_nameContext ctx) {
        this.plName = this.handleObjectName(ctx.getText());
    }

    public void enterProcedure_spec(PlSqlParser.Procedure_specContext ctx) {
        List<DBPLParam> plParamList = this.handleParameters(ctx.parameter());
        String proName = ctx.identifier().getText();
        String proNameWithoutQuotation = this.handleObjectName(proName);
        DBProcedure dbProcedure = new DBProcedure();
        dbProcedure.setProName(this.handleUpperCase(proName, proNameWithoutQuotation));
        dbProcedure.setParams(plParamList);
        dbProcedure.setStartline(ctx.getStart().getLine());
        dbProcedure.setStopLine(ctx.getStop().getLine());
        dbProcedure.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.procedureList.add(dbProcedure);
        this.doRecord(null, DBObjectType.PROCEDURE, proName);
    }

    public void enterProcedure_body(PlSqlParser.Procedure_bodyContext ctx) {
        List<DBPLParam> plParamList = this.handleParameters(ctx.parameter());
        String proName = ctx.identifier().getText();
        String proNameWithoutQuotation = this.handleObjectName(proName);
        DBProcedure dbProcedure = new DBProcedure();
        dbProcedure.setProName(this.handleUpperCase(proName, proNameWithoutQuotation));
        dbProcedure.setParams(plParamList);
        dbProcedure.setStartline(ctx.getStart().getLine());
        dbProcedure.setStopLine(ctx.getStop().getLine());
        dbProcedure.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.procedureList.add(dbProcedure);
        this.doRecord(null, DBObjectType.PROCEDURE, proName);
    }

    public void enterDrop_function(PlSqlParser.Drop_functionContext ctx) {
        this.doRecord(SqlType.DROP, DBObjectType.FUNCTION, ctx.function_name().getText());
    }

    public void enterAlter_function(PlSqlParser.Alter_functionContext ctx) {
        this.doRecord(SqlType.ALTER, DBObjectType.FUNCTION, ctx.function_name().getText());
    }

    public void enterCreate_function_body(PlSqlParser.Create_function_bodyContext ctx) {
        List<DBPLParam> plParamList = this.handleParameters(ctx.parameter());
        String funName = ctx.function_name().getText();
        String funNameWithoutQuotation = this.handleObjectName(funName);
        DBFunction dbFunction = new DBFunction();
        dbFunction.setFunName(this.handleUpperCase(funName, funNameWithoutQuotation));
        dbFunction.setParams(plParamList);
        dbFunction.setReturnType(ctx.type_spec().getText());
        dbFunction.setStartline(ctx.getStart().getLine());
        dbFunction.setStopLine(ctx.getStop().getLine());
        dbFunction.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.functionList.add(dbFunction);
        this.doRecord(SqlType.CREATE, DBObjectType.FUNCTION, funName);
    }

    public void enterFunction_name(PlSqlParser.Function_nameContext ctx) {
        this.plName = this.handleObjectName(ctx.getText());
    }

    public void enterFunction_spec(PlSqlParser.Function_specContext ctx) {
        List<DBPLParam> plParamList = this.handleParameters(ctx.parameter());
        String funName = ctx.identifier().getText();
        String funNameWithoutQuotation = this.handleObjectName(funName);
        DBFunction dbFunction = new DBFunction();
        dbFunction.setFunName(this.handleUpperCase(funName, funNameWithoutQuotation));
        dbFunction.setParams(plParamList);
        dbFunction.setReturnType(ctx.type_spec().getText());
        dbFunction.setStartline(ctx.getStart().getLine());
        dbFunction.setStopLine(ctx.getStop().getLine());
        dbFunction.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.functionList.add(dbFunction);
        this.doRecord(null, DBObjectType.FUNCTION, funName);
    }

    public void enterFunction_body(PlSqlParser.Function_bodyContext ctx) {
        List<DBPLParam> plParamList = this.handleParameters(ctx.parameter());
        String funName = ctx.identifier().getText();
        String funNameWithoutQuotation = this.handleObjectName(funName);
        DBFunction dbFunction = new DBFunction();
        dbFunction.setFunName(this.handleUpperCase(funName, funNameWithoutQuotation));
        dbFunction.setParams(plParamList);
        dbFunction.setReturnType(ctx.type_spec().getText());
        dbFunction.setStartline(ctx.getStart().getLine());
        dbFunction.setStopLine(ctx.getStop().getLine());
        dbFunction.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.functionList.add(dbFunction);
        this.doRecord(null, DBObjectType.FUNCTION, funName);
    }

    public void enterVariable_declaration(PlSqlParser.Variable_declarationContext ctx) {
        DBPLVariable variable = this.generatePLVariable(ctx);
        this.varibaleList.add(variable);
    }

    public void enterType_declaration(PlSqlParser.Type_declarationContext ctx) {
        String typeVar = ctx.identifier().getText();
        String typeName = null;
        if (Objects.nonNull(ctx.table_type_def())) {
            typeName = PLObjectType.TABLE_TYPE.name();
        } else if (Objects.nonNull(ctx.varray_type_def())) {
            typeName = PLObjectType.VARRAY_TYPE.name();
        } else if (Objects.nonNull(ctx.ref_cursor_type_def())) {
            typeName = PLObjectType.CURSOR_TYPE.name();
        } else if (Objects.nonNull(ctx.record_type_def())) {
            typeName = PLObjectType.RECORD_TYPE.name();
        }
        DBPLType plType = new DBPLType();
        plType.setTypeVariable(this.handleObjectName(typeVar));
        plType.setTypeName(typeName);
        this.typeList.add(plType);
    }

    public void enterCursor_declaration(PlSqlParser.Cursor_declarationContext ctx) {
        String cursorVar = ctx.identifier().getText();
        String cursorName = PLObjectType.CURSOR.name();
        DBPLType plType = new DBPLType();
        plType.setTypeVariable(this.handleObjectName(cursorVar));
        plType.setTypeName(cursorName);
        plType.setDdl(this.getDdl((ParserRuleContext)ctx));
        this.cursorList.add(plType);
    }

    public void enterAnonymous_block(PlSqlParser.Anonymous_blockContext ctx) {
        if (Objects.isNull(this.plType)) {
            this.plType = DBObjectType.ANONYMOUS_BLOCK.getName();
        }
        this.doRecord(SqlType.CREATE, DBObjectType.ANONYMOUS_BLOCK, null);
    }

    private List<DBPLParam> handleParameters(List<PlSqlParser.ParameterContext> parameterContextList) {
        ArrayList<DBPLParam> plParamList = new ArrayList<DBPLParam>();
        for (int i = 0; i < parameterContextList.size(); ++i) {
            PlSqlParser.ParameterContext currentContext = parameterContextList.get(i);
            DBPLParam plParam = new DBPLParam();
            plParam.setParamName(StringUtils.unquoteOracleIdentifier(currentContext.parameter_name().getText()));
            plParam.setSeqNum(i + 1);
            plParam.setDataType(currentContext.type_spec().getText());
            boolean hasInParam = CollectionUtils.isNotEmpty((Collection)currentContext.IN());
            boolean hasOutParam = CollectionUtils.isNotEmpty((Collection)currentContext.OUT());
            boolean hasInOutParam = CollectionUtils.isNotEmpty((Collection)currentContext.INOUT());
            if (hasInParam && hasOutParam || hasInOutParam) {
                plParam.setParamMode(DBPLParamMode.INOUT);
            } else if (hasOutParam) {
                plParam.setParamMode(DBPLParamMode.OUT);
            } else {
                plParam.setParamMode(DBPLParamMode.IN);
            }
            if (Objects.nonNull(currentContext.default_value_part())) {
                plParam.setDefaultValue(currentContext.default_value_part().expression().getText());
            }
            plParamList.add(plParam);
        }
        return plParamList;
    }

    private DBPLVariable generatePLVariable(PlSqlParser.Variable_declarationContext ctx) {
        String var = ctx.identifier().getText();
        String type = ctx.type_spec().getText();
        DBPLVariable variable = new DBPLVariable();
        variable.setVarName(this.handleObjectName(var));
        variable.setVarType(type);
        return variable;
    }

    private String handleObjectName(String name) {
        return StringUtils.unquoteOracleIdentifier(name);
    }

    private String handleUpperCase(String originalName, String name) {
        if (originalName.equals(name)) {
            return name.toUpperCase();
        }
        return name;
    }

    public void enterDrop_trigger(PlSqlParser.Drop_triggerContext ctx) {
        this.doRecord(SqlType.DROP, DBObjectType.TRIGGER, ctx.trigger_name().getText());
    }

    public void enterCreate_trigger(PlSqlParser.Create_triggerContext ctx) {
        this.doRecord(SqlType.CREATE, DBObjectType.TRIGGER, ctx.trigger_name().getText());
    }

    public void enterCreate_type(PlSqlParser.Create_typeContext ctx) {
        String rawTypeName = null;
        if (Objects.nonNull(ctx.type_body())) {
            rawTypeName = ctx.type_body().type_name().getText();
        } else if (Objects.nonNull(ctx.type_definition())) {
            rawTypeName = ctx.type_definition().type_name().getText();
        }
        this.doRecord(SqlType.CREATE, DBObjectType.TYPE, rawTypeName);
    }

    public void enterDrop_type(PlSqlParser.Drop_typeContext ctx) {
        this.doRecord(SqlType.DROP, DBObjectType.TYPE, ctx.type_name().getText());
    }

    public void enterCreate_index(PlSqlParser.Create_indexContext ctx) {
        this.doRecord(SqlType.CREATE, DBObjectType.INDEX, ctx.index_name().getText());
    }

    public void enterDrop_index(PlSqlParser.Drop_indexContext ctx) {
        this.doRecord(SqlType.DROP, DBObjectType.INDEX, ctx.index_name().getText());
    }

    public void enterAlter_index(PlSqlParser.Alter_indexContext ctx) {
        this.doRecord(SqlType.ALTER, DBObjectType.INDEX, ctx.index_name().getText());
    }

    public void enterCreate_user(PlSqlParser.Create_userContext ctx) {
        this.doRecord(SqlType.CREATE, DBObjectType.USER, ctx.user_object_name().getText());
    }

    public void enterAlter_user(PlSqlParser.Alter_userContext ctx) {
        this.doRecord(SqlType.ALTER, DBObjectType.USER, ((PlSqlParser.User_object_nameContext)ctx.user_object_name().get(0)).getText());
    }

    public void enterData_manipulation_language_statements(PlSqlParser.Data_manipulation_language_statementsContext ctx) {
        if (Objects.nonNull(ctx.select_statement()) && !ctx.select_statement().isEmpty()) {
            this.doRecord(SqlType.SELECT, null, null);
        }
    }

    private void doRecord(SqlType sqlType, DBObjectType dbObjectType, String rawPlName) {
        if (Objects.nonNull((Object)sqlType) && Objects.isNull((Object)this.sqlType)) {
            this.sqlType = sqlType;
        }
        if (Objects.nonNull((Object)dbObjectType) && Objects.isNull((Object)this.dbObjectType)) {
            this.dbObjectType = dbObjectType;
            this.plType = dbObjectType.getName();
        }
        if (Objects.nonNull(rawPlName) && Objects.isNull(this.plName)) {
            this.plName = this.handleObjectName(rawPlName);
        }
    }

    private String getDdl(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        int end = stop.getType() == 2241 ? stop.getStopIndex() - 1 : stop.getStopIndex();
        CharStream stream = start.getTokenSource().getInputStream();
        return stream.getText(Interval.of((int)start.getStartIndex(), (int)end));
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public DBObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    @Override
    public List<String> getDbObjectNameList() {
        return this.dbObjectNameList;
    }

    public String getPlName() {
        return this.plName;
    }

    public String getPlType() {
        return this.plType;
    }

    public List<DBPLVariable> getVaribaleList() {
        return this.varibaleList;
    }

    public List<DBPLType> getTypeList() {
        return this.typeList;
    }

    public List<DBPLType> getCursorList() {
        return this.cursorList;
    }

    public List<DBProcedure> getProcedureList() {
        return this.procedureList;
    }

    public List<DBFunction> getFunctionList() {
        return this.functionList;
    }

    public String getIsOrAs() {
        return this.isOrAs;
    }
}

