/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBDatabase;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.model.DBView;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.lang.NonNull;

public class OBMySQLBetween2277And3XSchemaAccessor
extends OBMySQLSchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLBetween2277And3XSchemaAccessor.class);
    protected final List<String> VIEW_AS_BASE_TABLE = Arrays.asList("time_zone", "time_zone_name", "time_zone_transition", "time_zone_transition_type");

    public OBMySQLBetween2277And3XSchemaAccessor(@NonNull JdbcOperations jdbcOperations) {
        super(jdbcOperations);
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/obmysql/obmysql_3_x.yaml");
    }

    @Override
    public DBDatabase getDatabase(String schemaName) {
        DBDatabase database = new DBDatabase();
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select database_id, database_name from oceanbase.gv$database where database_name=").value(schemaName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            database.setId(rs.getString("database_id"));
            database.setName(rs.getString("database_name"));
        });
        String sql = "SELECT DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata WHERE SCHEMA_NAME ='" + schemaName + "'";
        this.jdbcOperations.query(sql, rs -> {
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
        });
        return database;
    }

    @Override
    protected void fillIndexRange(List<DBTableIndex> indexList, String schemaName, String tableName) {
        this.setIndexRangeByDDL(indexList, schemaName, tableName);
        this.setIndexRangeByQuery(indexList, schemaName, tableName);
    }

    protected void setIndexRangeByQuery(List<DBTableIndex> indexList, String schemaName, String tableName) {
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("SELECT `table_id` from oceanbase.gv$table where database_name=");
            sb.value(schemaName);
            sb.append(" and");
            sb.append(" table_name=");
            sb.value(tableName);
            sb.append(" into @table_id");
            this.jdbcOperations.execute(sb.toString());
            sb = new MySQLSqlBuilder();
            sb.append("select database_name, table_type, index_type, replace(table_name, CONCAT('__idx_', @table_id, '_'),'') as ");
            sb.append(" index_name, case when index_type < 3 then true else false end as is_local_index from oceanbase.gv$table");
            sb.append(" where database_name=");
            sb.value(schemaName);
            sb.append(" and table_name like");
            sb.append(" CONCAT('__idx_', @table_id, '_%') and table_type=5");
            this.jdbcOperations.query(sb.toString(), (rs, num) -> {
                String indexName = rs.getString("index_name");
                Boolean isLocal = rs.getBoolean("is_local_index");
                indexList.forEach(dbTableIndex -> {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbTableIndex.getWarning()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)dbTableIndex.getName(), (CharSequence)indexName)) {
                        dbTableIndex.setGlobal(isLocal == false);
                    }
                });
                return indexName;
            });
        }
        catch (Exception ex) {
            this.fillWarning(indexList, DBObjectType.INDEX, "query oceanbase.gv$table failed to get index ddl failed");
            log.warn("Failed to fetch indices of table {} by querying `oceanbase.gv$table`", (Object)tableName, (Object)ex);
        }
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        DBTablePartition subPartition = new DBTablePartition();
        partition.setSubpartition(subPartition);
        DBTablePartitionOption partitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        partition.setPartitionOption(partitionOption);
        DBTablePartitionOption subPartitionOption = new DBTablePartitionOption();
        subPartitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        subPartition.setPartitionOption(subPartitionOption);
        ArrayList<DBTablePartitionDefinition> partitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        partition.setPartitionDefinitions(partitionDefinitions);
        ArrayList<DBTablePartitionDefinition> subPartitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        subPartition.setPartitionDefinitions(subPartitionDefinitions);
        String sql = this.sqlMapper.getSql("get-partition");
        this.jdbcOperations.query(sql, ps -> {
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
        }, (rs, rowNum) -> {
            partitionOption.setType(DBTablePartitionType.fromValue(rs.getString("partition_method")));
            partitionOption.setPartitionsNum(rs.getInt("part_num"));
            String expression = rs.getString("part_func_expr");
            if (StringUtils.isNotEmpty((CharSequence)expression)) {
                if (partitionOption.getType().supportExpression()) {
                    partitionOption.setExpression(expression);
                } else {
                    partitionOption.setColumnNames(Arrays.asList(expression.split(",")));
                }
            }
            partition.setSubpartitionTemplated(rs.getInt("is_sub_part_template") == 1);
            DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
            partitionDefinition.setName(rs.getString("part_name"));
            partitionDefinition.setOrdinalPosition(rs.getInt("part_id"));
            partitionDefinition.setType(DBTablePartitionType.fromValue(rs.getString("partition_method")));
            String description = null;
            if (partitionDefinition.getType() == DBTablePartitionType.LIST || partitionDefinition.getType() == DBTablePartitionType.LIST_COLUMNS) {
                description = rs.getString("list_val");
            } else if (partitionDefinition.getType() == DBTablePartitionType.RANGE || partitionDefinition.getType() == DBTablePartitionType.RANGE_COLUMNS) {
                description = rs.getString("high_bound_val");
            }
            partitionDefinition.fillValues(description);
            partitionDefinitions.add(partitionDefinition);
            DBTablePartitionType subPartType = DBTablePartitionType.fromValue(rs.getString("subpartition_method"));
            String subPartExpression = rs.getString("sub_part_func_expr");
            if ((subPartType == DBTablePartitionType.HASH || subPartType == DBTablePartitionType.KEY) && partition.getSubpartitionTemplated().booleanValue() && StringUtils.isNotBlank((CharSequence)subPartExpression)) {
                subPartitionOption.setType(subPartType);
                subPartitionOption.setPartitionsNum(rs.getInt("sub_part_num"));
                if (subPartType.supportExpression()) {
                    subPartitionOption.setExpression(subPartExpression);
                } else {
                    subPartitionOption.setColumnNames(Arrays.asList(subPartExpression.split(",")));
                }
            } else {
                partition.setWarning("Only support HASH/KEY subpartition currently");
            }
            return null;
        });
        return partition;
    }

    @Override
    public List<DBObjectIdentity> listSequences(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        if ("mysql".equals(schemaName) && this.VIEW_AS_BASE_TABLE.contains(tableName)) {
            DBView view = new DBView();
            view.setSchemaName("mysql");
            view.setViewName(tableName);
            return this.fillColumnInfoByDesc(view).getColumns();
        }
        return super.listTableColumns(schemaName, tableName);
    }
}

