/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.stats.oracle;

import com.oceanbase.tools.dbbrowser.model.DBMySQLProcess;
import com.oceanbase.tools.dbbrowser.model.DBSession;
import com.oceanbase.tools.dbbrowser.model.DBTableStats;
import com.oceanbase.tools.dbbrowser.stats.DBStatsAccessor;
import com.oceanbase.tools.dbbrowser.util.ALLDataDictTableNames;
import com.oceanbase.tools.dbbrowser.util.OracleDataDictTableNames;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.USERDataDictTableNames;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public abstract class BaseOBOracleStatsAccessor
implements DBStatsAccessor {
    private static final String QUERY_SESSION_FROM_PROCESSLIST = "SHOW FULL PROCESSLIST";
    final OracleDataDictTableNames dataDictTableNames = new ALLDataDictTableNames();
    final JdbcOperations jdbcOperations;

    public BaseOBOracleStatsAccessor(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public DBTableStats getTableStats(@NonNull String schema, @NonNull String tableName) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        DBTableStats stats = new DBTableStats();
        stats.setDataSizeInBytes(this.getTableSize(tableName));
        stats.setRowCount(this.getRowCount(schema, tableName));
        return stats;
    }

    @Override
    public List<DBSession> listAllSessions() {
        return this.jdbcOperations.query(QUERY_SESSION_FROM_PROCESSLIST, (RowMapper)new BeanPropertyRowMapper(DBMySQLProcess.class)).stream().map(DBMySQLProcess::toDBSession).collect(Collectors.toList());
    }

    private Long getTableSize(String tableName) {
        USERDataDictTableNames tableNames = new USERDataDictTableNames();
        String sql = this.sqlBuilder().append("SELECT BYTES FROM ").append(tableNames.SEGMENTS()).append(" WHERE SEGMENT_NAME = ").value(tableName).toString();
        List segSizes = this.jdbcOperations.query(sql, (rs, rowNum) -> rs.getLong("BYTES"));
        return segSizes.stream().mapToLong(value -> value).sum();
    }

    private Long getRowCount(String schemaName, String tableName) {
        String sql = this.sqlBuilder().append("SELECT NUM_ROWS FROM ").append(this.dataDictTableNames.TABLES()).append(" WHERE TABLE_NAME = ").value(tableName).append(" AND OWNER = ").value(schemaName).toString();
        return (Long)this.jdbcOperations.query(sql, rs -> {
            if (!rs.next()) {
                return null;
            }
            return rs.getLong("NUM_ROWS");
        });
    }

    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }
}

