/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template;

import com.oceanbase.tools.dbbrowser.model.DBView;
import com.oceanbase.tools.dbbrowser.model.DBViewColumn;
import com.oceanbase.tools.dbbrowser.template.DBObjectTemplate;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseViewTemplate
implements DBObjectTemplate<DBView> {
    private static final Logger log = LoggerFactory.getLogger(BaseViewTemplate.class);

    protected abstract String preHandle(String var1);

    protected abstract SqlBuilder sqlBuilder();

    protected abstract String doGenerateCreateObjectTemplate(SqlBuilder var1, DBView var2);

    @Override
    public String generateCreateObjectTemplate(@NotNull DBView dbObject) {
        Validate.notBlank((CharSequence)dbObject.getViewName(), (String)"View name can not be blank", (Object[])new Object[0]);
        Validate.isTrue((dbObject.getOperations() == null || dbObject.getViewUnits() != null ? 1 : 0) != 0, (String)"Unable to calculate while operation set but table not set", (Object[])new Object[0]);
        Validate.isTrue((dbObject.getOperations() != null || dbObject.getViewUnits() == null || dbObject.getViewUnits().size() == 1 ? 1 : 0) != 0, (String)"Unable to calculate while operation not set but table size not 1", (Object[])new Object[0]);
        Validate.isTrue((dbObject.getOperations() == null || dbObject.getViewUnits() == null || dbObject.getOperations().size() == 0 && dbObject.getViewUnits().size() == 0 || dbObject.getOperations().size() == dbObject.getViewUnits().size() - 1 ? 1 : 0) != 0, (String)"Unable to calculate, operationSize<>tableSize-1", (Object[])new Object[0]);
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append(this.preHandle("create or replace view ")).identifier(dbObject.getViewName()).append(this.preHandle(" as"));
        ViewCreateParameters params = new ViewCreateParameters(dbObject);
        params.getSubParameters().forEach(p -> {
            if (Objects.isNull(p.getViewUnits()) && Objects.isNull(p.getColumns())) {
                sqlBuilder.append("\n").append(this.preHandle(p.getOperations().get(0))).space();
                return;
            }
            this.handleQuery(sqlBuilder, (ViewCreateSubParameters)p);
        });
        return this.doGenerateCreateObjectTemplate(sqlBuilder, dbObject);
    }

    private void handleQuery(SqlBuilder sqlBuilder, ViewCreateSubParameters subParam) {
        sqlBuilder.append("\n").append(this.preHandle("select"));
        List<DBViewColumn> columns = subParam.getColumns();
        if (CollectionUtils.isEmpty(columns)) {
            sqlBuilder.space().append("\n\t").append("*");
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                DBViewColumn column = subParam.getColumns().get(i);
                sqlBuilder.append("\n\t");
                this.handleColumnName(sqlBuilder, column, i, subParam);
                if (i >= columns.size() - 1) continue;
                sqlBuilder.append(",");
            }
        }
        sqlBuilder.append(this.preHandle("\nfrom"));
        this.handleJoin(sqlBuilder, subParam);
    }

    private void handleColumnName(SqlBuilder sqlBuilder, DBViewColumn currentColumn, int index, ViewCreateSubParameters subParam) {
        String currentName = currentColumn.getColumnName();
        String currentAlias = currentColumn.getAliasName();
        if (Objects.isNull(currentColumn.getDbName()) || Objects.isNull(currentColumn.getTableName())) {
            sqlBuilder.append(currentName);
            if (StringUtils.isNotEmpty((CharSequence)currentAlias)) {
                sqlBuilder.append(this.preHandle(" as ")).append(currentAlias);
            }
            return;
        }
        String tableAlias = currentColumn.getTableAliasName();
        if (StringUtils.isNotEmpty((CharSequence)tableAlias)) {
            sqlBuilder.append(tableAlias).append(".").identifier(currentName);
            if (StringUtils.isNotEmpty((CharSequence)currentAlias)) {
                sqlBuilder.append(this.preHandle(" as ")).append(currentAlias);
            }
            return;
        }
        boolean duplicateAlias = false;
        for (int i = 0; i < subParam.getColumns().size(); ++i) {
            if (i == index) continue;
            DBViewColumn column = subParam.getColumns().get(i);
            if (!StringUtils.isNotEmpty((CharSequence)currentAlias) || !currentAlias.equals(column.getAliasName())) continue;
            duplicateAlias = true;
        }
        SqlBuilder prefixBuilder = this.sqlBuilder();
        if (!subParam.getParent().isSingleSchema()) {
            prefixBuilder.identifier(currentColumn.getDbName()).append(".");
        }
        prefixBuilder.identifier(currentColumn.getTableName());
        if (!subParam.getParent().isSingleTable()) {
            sqlBuilder.append(prefixBuilder.toString()).append(".");
        }
        sqlBuilder.identifier(currentName);
        if (StringUtils.isNotEmpty((CharSequence)currentAlias)) {
            sqlBuilder.append(this.preHandle(" as "));
            if (duplicateAlias) {
                sqlBuilder.append(prefixBuilder.toString()).append(".");
            }
            sqlBuilder.append(currentAlias);
        }
    }

    private void handleJoin(SqlBuilder sqlBuilder, ViewCreateSubParameters subParam) {
        boolean hasCommaOperation = false;
        List<DBView.DBViewUnit> units = subParam.getViewUnits();
        sqlBuilder.append("\n\t");
        for (int i = 0; i < units.size(); ++i) {
            DBView.DBViewUnit currentUnit = units.get(i);
            sqlBuilder.identifier(currentUnit.getDbName()).append(".").identifier(currentUnit.getTableName());
            if (currentUnit.getTableAliasName() != null) {
                sqlBuilder.space().append(currentUnit.getTableAliasName());
            }
            if (i > 0) {
                String preOperation = subParam.getOperations().get(i - 1);
                if (",".equals(preOperation)) {
                    hasCommaOperation = true;
                } else {
                    sqlBuilder.append(this.preHandle(" on")).append(" /* TODO enter attribute to join on here */");
                }
            }
            if (i >= units.size() - 1) continue;
            String currentOperation = subParam.getOperations().get(i);
            if (!",".equals(currentOperation)) {
                sqlBuilder.append("\n\t");
            }
            sqlBuilder.append(this.preHandle(currentOperation)).space();
        }
        if (!hasCommaOperation) {
            return;
        }
        sqlBuilder.append(this.preHandle("\nwhere")).append(" /* TODO enter condition clause for where */");
    }

    private static class ViewCreateParameters {
        private List<ViewCreateSubParameters> subParameters = new ArrayList<ViewCreateSubParameters>();
        private Set<String> tableSet = new HashSet<String>();
        private Set<String> schemaSet = new HashSet<String>();

        public ViewCreateParameters(DBView view) {
            this.transform(view);
        }

        public boolean isSingleSchema() {
            return this.schemaSet.size() == 1;
        }

        public boolean isSingleTable() {
            return this.tableSet.size() == 1;
        }

        private void transform(DBView view) {
            int operationIndex;
            List<DBView.DBViewUnit> viewUnits = view.getViewUnits();
            List<String> operations = view.getOperations();
            int unitIndex = 0;
            for (operationIndex = 0; operationIndex < operations.size(); ++operationIndex) {
                String currentOperation = operations.get(operationIndex);
                if (this.isJoin(currentOperation)) continue;
                this.collectColumns(view, unitIndex, operationIndex);
                ViewCreateSubParameters currentSubParam = new ViewCreateSubParameters(this);
                currentSubParam.addOperation(currentOperation);
                this.subParameters.add(currentSubParam);
                unitIndex = operationIndex + 1;
            }
            if (unitIndex < viewUnits.size()) {
                this.collectColumns(view, unitIndex, operationIndex);
            }
        }

        private boolean isJoin(String operation) {
            return StringUtils.containsAnyIgnoreCase((CharSequence)operation, (CharSequence[])new CharSequence[]{"join"}) || ",".equals(operation);
        }

        private void collectColumns(DBView view, int unitIndex, int operationIndex) {
            ViewCreateSubParameters subParam = new ViewCreateSubParameters(this);
            List<DBView.DBViewUnit> dbViewUnits = view.getViewUnits().subList(unitIndex, operationIndex + 1);
            subParam.setViewUnits(dbViewUnits);
            List<String> operationSub = view.getOperations().subList(unitIndex, operationIndex);
            subParam.setOperations(operationSub);
            HashSet<String> localTableSet = new HashSet<String>();
            for (DBView.DBViewUnit unit : dbViewUnits) {
                localTableSet.add(unit.getDbName() + "." + unit.getTableName());
                this.schemaSet.add(unit.getDbName());
            }
            ArrayList<DBViewColumn> columns = new ArrayList<DBViewColumn>();
            if (!Objects.isNull(view.getCreateColumns())) {
                for (DBViewColumn column : view.getCreateColumns()) {
                    if (Objects.isNull(column.getDbName()) || Objects.isNull(column.getTableName())) {
                        columns.add(column);
                    }
                    if (!localTableSet.contains(column.getDbName() + "." + column.getTableName())) continue;
                    columns.add(column);
                }
            }
            subParam.setColumns(columns);
            this.tableSet.addAll(localTableSet);
            this.subParameters.add(subParam);
        }

        public List<ViewCreateSubParameters> getSubParameters() {
            return this.subParameters;
        }

        public Set<String> getTableSet() {
            return this.tableSet;
        }

        public Set<String> getSchemaSet() {
            return this.schemaSet;
        }

        public void setSubParameters(List<ViewCreateSubParameters> subParameters) {
            this.subParameters = subParameters;
        }

        public void setTableSet(Set<String> tableSet) {
            this.tableSet = tableSet;
        }

        public void setSchemaSet(Set<String> schemaSet) {
            this.schemaSet = schemaSet;
        }
    }

    private static class ViewCreateSubParameters {
        private List<DBView.DBViewUnit> viewUnits;
        private List<DBViewColumn> columns;
        private List<String> operations;
        private final ViewCreateParameters parent;

        public ViewCreateSubParameters(ViewCreateParameters parent) {
            this.parent = parent;
        }

        public void addOperation(String operation) {
            if (Objects.isNull(this.operations)) {
                this.operations = new ArrayList<String>();
            }
            this.operations.add(operation);
        }

        public void setViewUnits(List<DBView.DBViewUnit> viewUnits) {
            this.viewUnits = viewUnits;
        }

        public void setColumns(List<DBViewColumn> columns) {
            this.columns = columns;
        }

        public void setOperations(List<String> operations) {
            this.operations = operations;
        }

        public List<DBView.DBViewUnit> getViewUnits() {
            return this.viewUnits;
        }

        public List<DBViewColumn> getColumns() {
            return this.columns;
        }

        public List<String> getOperations() {
            return this.operations;
        }

        public ViewCreateParameters getParent() {
            return this.parent;
        }
    }
}

