/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBTableConstraintEditor;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class MySQLConstraintEditor
extends DBTableConstraintEditor {
    @Override
    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }

    @Override
    protected void appendConstraintOptions(DBTableConstraint constraint, SqlBuilder sqlBuilder) {
        super.appendConstraintOptions(constraint, sqlBuilder);
        if (Objects.nonNull((Object)constraint.getOnUpdateRule())) {
            sqlBuilder.append(" ON UPDATE ").append(constraint.getOnUpdateRule().getValue());
        }
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBTableConstraint constraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        DBConstraintType type = constraint.getType();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(constraint)).append(" DROP ");
        if (type == DBConstraintType.PRIMARY_KEY) {
            sqlBuilder.append("PRIMARY KEY");
        } else if (type == DBConstraintType.CHECK) {
            sqlBuilder.append("CONSTRAINT ").identifier(constraint.getName());
        } else if (type == DBConstraintType.FOREIGN_KEY) {
            sqlBuilder.append("FOREIGN KEY ").identifierIf(constraint.getName(), StringUtils.isNotEmpty((CharSequence)constraint.getName()));
        } else {
            sqlBuilder.append("KEY ").identifier(constraint.getName());
        }
        return sqlBuilder.toString();
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTableConstraint oldConstraint, @NotNull DBTableConstraint newConstraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (newConstraint.getType() == DBConstraintType.FOREIGN_KEY) {
            String drop = this.generateDropObjectDDL(oldConstraint);
            sqlBuilder.append(drop).append(";").line().append(this.generateCreateObjectDDL(newConstraint)).append(";").line();
        } else {
            sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(oldConstraint)).append(" RENAME KEY ").identifier(oldConstraint.getName()).append(" TO ").identifier(newConstraint.getName()).append(";").line();
        }
        return sqlBuilder.toString();
    }
}

