/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;

public class MySQLDBTablePartitionEditor
extends DBTablePartitionEditor {
    @Override
    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }

    @Override
    protected void appendDefinitions(DBTablePartition partition, SqlBuilder sqlBuilder) {
        DBTablePartitionType type = partition.getPartitionOption().getType();
        if ((type == DBTablePartitionType.HASH || type == DBTablePartitionType.KEY) && CollectionUtils.isEmpty(partition.getPartitionDefinitions())) {
            return;
        }
        sqlBuilder.append("(\n");
        boolean isFirstColumn = true;
        for (DBTablePartitionDefinition definition : partition.getPartitionDefinitions()) {
            if (!isFirstColumn) {
                sqlBuilder.append(",").line();
            }
            isFirstColumn = false;
            this.appendDefinition(partition.getPartitionOption(), definition, sqlBuilder);
        }
        sqlBuilder.append("\n)");
    }

    @Override
    protected void appendDefinition(DBTablePartitionOption option, DBTablePartitionDefinition definition, SqlBuilder sqlBuilder) {
        sqlBuilder.append("PARTITION ").identifier(definition.getName());
        if (option.getType() == DBTablePartitionType.RANGE || option.getType() == DBTablePartitionType.RANGE_COLUMNS) {
            if (Objects.nonNull(definition.getMaxValues())) {
                sqlBuilder.append(" VALUES LESS THAN (").append(String.join((CharSequence)",", definition.getMaxValues())).append(")");
            }
        } else if ((option.getType() == DBTablePartitionType.LIST || option.getType() == DBTablePartitionType.LIST_COLUMNS) && Objects.nonNull(definition.getValuesList())) {
            sqlBuilder.append(" VALUES IN (").append(DBSchemaAccessorUtil.parseListRangeValuesList(definition.getValuesList())).append(")");
        }
    }

    @Override
    protected String generateAddPartitionDefinitionDDL(@NotNull DBTablePartitionDefinition definition, @NotNull DBTablePartitionOption option, String fullyQualifiedTableName) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(fullyQualifiedTableName).append(" ADD PARTITION(");
        this.appendDefinition(option, definition, sqlBuilder);
        sqlBuilder.append(");").line();
        return sqlBuilder.toString();
    }

    @Override
    protected void generateCreateTemplateSubPartition(DBTablePartition partition, SqlBuilder sqlBuilder) {
        if (Objects.isNull(partition.getSubpartition())) {
            return;
        }
        DBTablePartitionOption subPartOption = partition.getSubpartition().getPartitionOption();
        if (Objects.isNull(subPartOption)) {
            return;
        }
        if (partition.getSubpartitionTemplated().booleanValue() && (subPartOption.getType() == DBTablePartitionType.HASH || subPartOption.getType() == DBTablePartitionType.KEY)) {
            sqlBuilder.append("SUBPARTITION BY ").append(subPartOption.getType().getValue()).append("(");
            this.appendExpression(partition.getSubpartition(), sqlBuilder);
            sqlBuilder.append(") subpartitions ").append(String.valueOf(subPartOption.getPartitionsNum()));
        }
    }
}

