/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.MySQLTableEditor;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Objects;

public class OBMySQLTableEditor
extends MySQLTableEditor {
    public OBMySQLTableEditor(DBObjectEditor<DBTableIndex> indexEditor, DBObjectEditor<DBTableColumn> columnEditor, DBObjectEditor<DBTableConstraint> constraintEditor, DBObjectEditor<DBTablePartition> partitionEditor) {
        super(indexEditor, columnEditor, constraintEditor, partitionEditor);
    }

    @Override
    protected void appendMoreTableOptions(DBTable table, SqlBuilder sqlBuilder) {
        if (Objects.isNull(table.getTableOptions())) {
            return;
        }
        DBTable.DBTableOptions options = table.getTableOptions();
        if (Objects.nonNull(options.getReplicaNum())) {
            sqlBuilder.append("REPLICA_NUM = ").append(String.valueOf(options.getReplicaNum())).space();
        }
        if (Objects.nonNull(options.getUseBloomFilter())) {
            sqlBuilder.append("USE_BLOOM_FILTER = ").append(options.getUseBloomFilter() != false ? "TRUE" : "FALSE").space();
        }
        if (Objects.nonNull(options.getTabletSize())) {
            sqlBuilder.append("TABLET_SIZE = ").append(String.valueOf(options.getTabletSize())).space();
        }
    }
}

