/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTableEditor;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;

public class OracleTableEditor
extends DBTableEditor {
    public OracleTableEditor(DBObjectEditor<DBTableIndex> indexEditor, DBObjectEditor<DBTableColumn> columnEditor, DBObjectEditor<DBTableConstraint> constraintEditor, DBObjectEditor<DBTablePartition> partitionEditor) {
        super(indexEditor, columnEditor, constraintEditor, partitionEditor);
    }

    @Override
    protected boolean createIndexWhenCreatingTable() {
        return false;
    }

    @Override
    protected void appendTableOptions(DBTable table, SqlBuilder sqlBuilder) {
        if (Objects.isNull(table.getTableOptions())) {
            return;
        }
        DBTable.DBTableOptions options = table.getTableOptions();
        if (StringUtils.isNotBlank((CharSequence)options.getCompressionOption())) {
            sqlBuilder.append("COMPRESS ").append(options.getCompressionOption()).space();
        }
        if (Objects.nonNull(options.getReplicaNum())) {
            sqlBuilder.append("REPLICA_NUM = ").append(String.valueOf(options.getReplicaNum())).space();
        }
        if (Objects.nonNull(options.getUseBloomFilter())) {
            sqlBuilder.append("USE_BLOOM_FILTER = ").append(options.getUseBloomFilter() != false ? "TRUE" : "FALSE").space();
        }
        if (Objects.nonNull(options.getTabletSize())) {
            sqlBuilder.append("TABLET_SIZE = ").append(String.valueOf(options.getTabletSize())).space();
        }
    }

    @Override
    protected void generateUpdateTableOptionDDL(DBTable oldTable, DBTable newTable, SqlBuilder sqlBuilder) {
        if (!StringUtils.equals((CharSequence)oldTable.getTableOptions().getComment(), (CharSequence)newTable.getTableOptions().getComment())) {
            this.appendTableComment(newTable, sqlBuilder);
        }
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBTable table) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append(super.generateCreateObjectDDL(table));
        if (CollectionUtils.isNotEmpty(this.excludePrimaryKeyIndex(table.getIndexes(), table.getConstraints()))) {
            for (DBTableIndex index : table.getIndexes()) {
                sqlBuilder.append(this.indexEditor.generateCreateObjectDDL(index)).append(";").line();
            }
        }
        return sqlBuilder.toString();
    }

    @Override
    protected void appendColumnComment(@NotNull DBTable table, @NotNull SqlBuilder sqlBuilder) {
        if (CollectionUtils.isEmpty(table.getColumns())) {
            return;
        }
        table.getColumns().forEach(column -> {
            if (Objects.nonNull(column.getComment())) {
                sqlBuilder.append("COMMENT ON COLUMN ").append(this.getFullyQualifiedTableName(table)).append(".").identifier(column.getName()).append(" IS ").value(column.getComment()).append(";").line();
            }
        });
    }

    @Override
    protected void appendTableComment(DBTable table, SqlBuilder sqlBuilder) {
        if (Objects.nonNull(table.getTableOptions()) && Objects.nonNull(table.getTableOptions().getComment())) {
            sqlBuilder.append("COMMENT ON TABLE ").append(this.getFullyQualifiedTableName(table)).append(" IS ").value(table.getTableOptions().getComment()).append(";\n");
        }
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTable oldTable, @NotNull DBTable newTable) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("RENAME ").identifier(oldTable.getName()).append(" TO ").identifier(newTable.getName());
        return sqlBuilder.toString();
    }
}

