/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import com.oceanbase.tools.dbbrowser.parser.listener.LogErrorListener;
import com.oceanbase.tools.dbbrowser.parser.listener.MysqlModePLParserListener;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModePLParserListener;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModeParserListener;
import com.oceanbase.tools.dbbrowser.parser.result.ParseMysqlPLResult;
import com.oceanbase.tools.dbbrowser.parser.result.ParseOraclePLResult;
import com.oceanbase.tools.sqlparser.FastFailErrorListener;
import com.oceanbase.tools.sqlparser.FastFailErrorStrategy;
import com.oceanbase.tools.sqlparser.oboracle.PLLexer;
import com.oceanbase.tools.sqlparser.oracle.PlSqlLexer;
import com.oceanbase.tools.sqlparser.oracle.PlSqlParser;
import com.oceanbase.tools.sqlparser.util.CaseChangingCharStream;
import com.oceanbase.tools.sqlparser.util.TimeoutTokenStream;
import lombok.NonNull;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLParser {
    private static final Logger log = LoggerFactory.getLogger(PLParser.class);

    public static ParseMysqlPLResult parseObMysql(String pl) {
        return PLParser.parseObMysql(pl, 0L);
    }

    public static ParseMysqlPLResult parseObMysql(String pl, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        CodePointCharStream input = CharStreams.fromString((String)pl);
        com.oceanbase.tools.sqlparser.obmysql.PLLexer lexer = new com.oceanbase.tools.sqlparser.obmysql.PLLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new FastFailErrorListener());
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        com.oceanbase.tools.sqlparser.obmysql.PLParser parser = new com.oceanbase.tools.sqlparser.obmysql.PLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FastFailErrorListener());
        parser.setErrorHandler((ANTLRErrorStrategy)new FastFailErrorStrategy());
        log.info("Time cost for pl parsing is {}ms, pl={}", (Object)(System.currentTimeMillis() - startTime), (Object)pl);
        return PLParser.parseObMysql((ParseTree)parser.stmt_block());
    }

    public static ParseMysqlPLResult parseObMysql(@NonNull ParseTree parseTree) {
        if (parseTree == null) {
            throw new NullPointerException("parseTree is marked non-null but is null");
        }
        MysqlModePLParserListener listener = new MysqlModePLParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, parseTree);
        return new ParseMysqlPLResult(listener);
    }

    public static ParseOraclePLResult parseObOracle(String pl) {
        return PLParser.parseObOracle(pl, 0L);
    }

    public static ParseOraclePLResult parseObOracle(String pl, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        ParseOraclePLResult result = PLParser.parseByRule(pl, 0, timeoutMillis);
        if (result.isEmpty()) {
            log.warn("Pl parse failed by using pl_entry_stmt_list rule, try pl_ddl_stmt rule, sql={}", (Object)pl);
            result = PLParser.parseByRule(pl, 2, timeoutMillis);
        }
        log.info("Time cost for pl parsing is {}ms, pl={}", (Object)(System.currentTimeMillis() - startTime), (Object)pl);
        return result;
    }

    private static ParseOraclePLResult parseByRule(String pl, int paserRule, long timeoutMillis) {
        CodePointCharStream input = CharStreams.fromString((String)pl);
        PLLexer lexer = new PLLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new FastFailErrorListener());
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        com.oceanbase.tools.sqlparser.oboracle.PLParser parser = new com.oceanbase.tools.sqlparser.oboracle.PLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FastFailErrorListener());
        parser.setErrorHandler((ANTLRErrorStrategy)new FastFailErrorStrategy());
        if (paserRule == 2) {
            return PLParser.parseObOracle((ParseTree)parser.pl_ddl_stmt());
        }
        return PLParser.parseObOracle((ParseTree)parser.pl_entry_stmt_list());
    }

    public static ParseOraclePLResult parseObOracle(@NonNull ParseTree parseTree) {
        if (parseTree == null) {
            throw new NullPointerException("parseTree is marked non-null but is null");
        }
        OracleModePLParserListener listener = new OracleModePLParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, parseTree);
        return new ParseOraclePLResult(listener);
    }

    public static ParseOraclePLResult parseOracle(String pl) {
        return PLParser.parseOracle(pl, 0L);
    }

    public static ParseOraclePLResult parseOracle(String pl, long timeoutMillis) {
        CodePointCharStream input = CharStreams.fromString((String)pl);
        CaseChangingCharStream caseChangingCharStream = new CaseChangingCharStream((CharStream)input, true);
        PlSqlLexer lexer = new PlSqlLexer((CharStream)caseChangingCharStream);
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        PlSqlParser parser = new PlSqlParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new LogErrorListener());
        return PLParser.parseOracle((ParseTree)parser.sql_script());
    }

    public static ParseOraclePLResult parseOracle(@NonNull ParseTree parseTree) {
        if (parseTree == null) {
            throw new NullPointerException("parseTree is marked non-null but is null");
        }
        OracleModeParserListener listener = new OracleModeParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, parseTree);
        return new ParseOraclePLResult(listener);
    }
}

