/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBColumnTypeDisplay;
import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBPLObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.mysql.BaseOBMySQLLessThan2277SchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

public class OBMySQLNoGreaterThan1479SchemaAccessor
extends BaseOBMySQLLessThan2277SchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLNoGreaterThan1479SchemaAccessor.class);
    private final String tenantName;
    protected JdbcOperations sysJdbcOperations;
    private static final Set<String> SPECIAL_TYPE_NAME = new HashSet<String>();

    public OBMySQLNoGreaterThan1479SchemaAccessor(JdbcOperations jdbcOperations, JdbcOperations sysJdbcOperations, String tenantName) {
        super(jdbcOperations, DBSchemaAccessorSqlMappers.get("schema/sql/obmysql/obmysql_1_4_79.yaml"));
        this.tenantName = tenantName;
        this.sysJdbcOperations = sysJdbcOperations;
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        try {
            return this.listBaseTables(schemaName, tableNameLike);
        }
        catch (Exception e) {
            log.warn("List tables failed, reason={}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        if (this.sysJdbcOperations == null) {
            throw new NullPointerException("Query table partition info failed, please confirm that you have sys read permission");
        }
        DBTablePartition subPartition = new DBTablePartition();
        partition.setSubpartition(subPartition);
        DBTablePartitionOption partitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        partition.setPartitionOption(partitionOption);
        DBTablePartitionOption subPartitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        subPartition.setPartitionOption(subPartitionOption);
        ArrayList<DBTablePartitionDefinition> partitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        partition.setPartitionDefinitions(partitionDefinitions);
        ArrayList<DBTablePartitionDefinition> subPartitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        subPartition.setPartitionDefinitions(subPartitionDefinitions);
        String sql = this.sqlMapper.getSql("get-partition");
        this.sysJdbcOperations.query(sql, ps -> {
            ps.setString(1, this.tenantName);
            ps.setString(2, schemaName);
            ps.setString(3, tableName);
        }, (rs, rowNum) -> {
            partitionOption.setType(DBTablePartitionType.fromValue(rs.getString("partition_method")));
            partitionOption.setPartitionsNum(rs.getInt("part_num"));
            String expression = rs.getString("part_func_expr");
            if (StringUtils.isNotEmpty((CharSequence)expression)) {
                if (partitionOption.getType().supportExpression()) {
                    partitionOption.setExpression(expression);
                } else {
                    partitionOption.setColumnNames(Arrays.asList(expression.split(",")));
                }
            }
            partition.setSubpartitionTemplated(rs.getInt("is_sub_part_template") == 1);
            DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
            partitionDefinition.setName(rs.getString("part_name"));
            partitionDefinition.setOrdinalPosition(rs.getInt("part_id"));
            partitionDefinition.setType(DBTablePartitionType.fromValue(rs.getString("partition_method")));
            String description = null;
            if (partitionDefinition.getType() == DBTablePartitionType.RANGE || partitionDefinition.getType() == DBTablePartitionType.RANGE_COLUMNS) {
                description = rs.getString("high_bound_val");
            }
            partitionDefinition.fillValues(description);
            partitionDefinitions.add(partitionDefinition);
            DBTablePartitionType subPartType = DBTablePartitionType.fromValue(rs.getString("subpartition_method"));
            String subPartExpression = rs.getString("sub_part_func_expr");
            if ((subPartType == DBTablePartitionType.HASH || subPartType == DBTablePartitionType.KEY) && partition.getSubpartitionTemplated().booleanValue() && StringUtils.isNotBlank((CharSequence)subPartExpression)) {
                subPartitionOption.setType(subPartType);
                subPartitionOption.setPartitionsNum(rs.getInt("sub_part_num"));
                if (subPartType.supportExpression()) {
                    subPartitionOption.setExpression(subPartExpression);
                } else {
                    subPartitionOption.setColumnNames(Arrays.asList(subPartExpression.split(",")));
                }
            } else {
                partition.setWarning("Only support HASH/KEY subpartition currently, please check comparing ddl");
            }
            return null;
        });
        return partition;
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        List<DBTableColumn> columns = super.listTableColumns(schemaName, tableName);
        if (CollectionUtils.isNotEmpty(columns)) {
            columns.forEach(column -> this.fillPrecisionAndScale((DBTableColumn)column));
        }
        return columns;
    }

    @Override
    public Map<String, List<DBTableColumn>> listTableColumns(String schemaName) {
        Map<String, List<DBTableColumn>> tableName2Columns = super.listTableColumns(schemaName);
        for (List<DBTableColumn> columnList : tableName2Columns.values()) {
            if (!CollectionUtils.isNotEmpty(columnList)) continue;
            columnList.forEach(column -> this.fillPrecisionAndScale((DBTableColumn)column));
        }
        return tableName2Columns;
    }

    @Override
    protected void fillIndexRange(List<DBTableIndex> indexList, String schemaName, String tableName) {
        indexList.forEach(index -> index.setGlobal(false));
    }

    private void fillPrecisionAndScale(DBTableColumn column) {
        if (SPECIAL_TYPE_NAME.contains(column.getTypeName())) {
            String precisionAndScale = DBSchemaAccessorUtil.parsePrecisionAndScale(column.getFullTypeName());
            if (StringUtils.isBlank((CharSequence)precisionAndScale)) {
                return;
            }
            DBColumnTypeDisplay display = DBColumnTypeDisplay.fromName(column.getTypeName());
            if (precisionAndScale.contains(",")) {
                String[] seg = precisionAndScale.split(",");
                if (seg.length == 2) {
                    if (display.displayPrecision()) {
                        column.setPrecision(Long.parseLong(seg[0]));
                    }
                    if (display.displayScale()) {
                        column.setScale(Integer.parseInt(seg[1]));
                    }
                }
            } else if (display.displayPrecision()) {
                column.setPrecision(Long.parseLong(precisionAndScale));
            }
        }
    }

    @Override
    public List<DBTablePartition> listTablePartitions(String tenantName, String schemaName, String tableName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listFunctions(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listProcedures(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBFunction getFunction(String schemaName, String functionName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBProcedure getProcedure(String schemaName, String procedureName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    static {
        SPECIAL_TYPE_NAME.add("bit");
        SPECIAL_TYPE_NAME.add("int");
        SPECIAL_TYPE_NAME.add("tinyint");
        SPECIAL_TYPE_NAME.add("smallint");
        SPECIAL_TYPE_NAME.add("mediumint");
        SPECIAL_TYPE_NAME.add("bigint");
        SPECIAL_TYPE_NAME.add("float");
        SPECIAL_TYPE_NAME.add("double");
    }
}

